/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.hibernate.cache.entry.CacheEntry;

public class VersionAwareMapMergePolicy
implements MapMergePolicy {
    @Override
    public Object merge(String mapName, EntryView mergingEntry, EntryView existingEntry) {
        Object existingValue = existingEntry != null ? existingEntry.getValue() : null;
        Object mergingValue = mergingEntry.getValue();
        if (existingValue != null && existingValue instanceof CacheEntry && mergingValue != null && mergingValue instanceof CacheEntry) {
            CacheEntry existingCacheEntry = existingValue;
            CacheEntry mergingCacheEntry = (CacheEntry)mergingValue;
            Object mergingVersionObject = mergingCacheEntry.getVersion();
            Object existingVersionObject = existingCacheEntry.getVersion();
            if (mergingVersionObject != null && existingVersionObject != null && mergingVersionObject instanceof Comparable && existingVersionObject instanceof Comparable) {
                Comparable mergingVersion = (Comparable)mergingVersionObject;
                Comparable existingVersion = (Comparable)existingVersionObject;
                if (mergingVersion.compareTo(existingVersion) > 0) {
                    return mergingValue;
                }
                return existingValue;
            }
        }
        return mergingValue;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }
}

