/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction.impl.evaluator;

import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionCandidate;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.util.Clock;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractEvictionPolicyEvaluator<A, E extends Evictable>
implements EvictionPolicyEvaluator<A, E> {
    protected abstract Evictable selectEvictableAsPolicy(Evictable var1, Evictable var2);

    @Override
    public <C extends EvictionCandidate<A, E>> Iterable<C> evaluate(Iterable<C> evictionCandidates) {
        EvictionCandidate evictionCandidate = null;
        long now = Clock.currentTimeMillis();
        for (EvictionCandidate candidate : evictionCandidates) {
            if (evictionCandidate == null) {
                evictionCandidate = candidate;
                continue;
            }
            Object evictable = candidate.getEvictable();
            if (evictable == null) continue;
            if (this.isExpired(now, (Evictable)evictable)) {
                return candidate instanceof Iterable ? (Set<EvictionCandidate>)((Object)candidate) : Collections.singleton(candidate);
            }
            Evictable selected = this.selectEvictableAsPolicy((Evictable)evictionCandidate.getEvictable(), (Evictable)evictable);
            if (selected != evictable) continue;
            evictionCandidate = candidate;
        }
        if (evictionCandidate == null) {
            return null;
        }
        return evictionCandidate instanceof Iterable ? (Set<Object>)((Object)evictionCandidate) : Collections.singleton(evictionCandidate);
    }

    private boolean isExpired(long now, Evictable evictable) {
        if (evictable instanceof Expirable) {
            Expirable expirable = (Expirable)((Object)evictable);
            return expirable.isExpiredAt(now);
        }
        return false;
    }
}

