/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.partition.InternalPartitionLostEvent;
import com.hazelcast.spi.ClientAwareService;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.NotifiableEventListener;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.QuorumAwareService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.ReplicationSupportingService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.StatisticsAwareService;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.wan.WanReplicationEvent;
import java.util.Map;
import java.util.Properties;

public class MapService
implements ManagedService,
MigrationAwareService,
TransactionalService,
RemoteService,
EventPublishingService<Object, ListenerAdapter>,
PostJoinAwareService,
SplitBrainHandlerService,
ReplicationSupportingService,
StatisticsAwareService,
PartitionAwareService,
ClientAwareService,
QuorumAwareService,
NotifiableEventListener {
    public static final String SERVICE_NAME = "hz:impl:mapService";
    protected ManagedService managedService;
    protected MigrationAwareService migrationAwareService;
    protected TransactionalService transactionalService;
    protected RemoteService remoteService;
    protected EventPublishingService eventPublishingService;
    protected PostJoinAwareService postJoinAwareService;
    protected SplitBrainHandlerService splitBrainHandlerService;
    protected ReplicationSupportingService replicationSupportingService;
    protected StatisticsAwareService statisticsAwareService;
    protected PartitionAwareService partitionAwareService;
    protected ClientAwareService clientAwareService;
    protected QuorumAwareService quorumAwareService;
    protected MapServiceContext mapServiceContext;

    @Override
    public void dispatchEvent(Object event, ListenerAdapter listener) {
        this.eventPublishingService.dispatchEvent(event, listener);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.managedService.init(nodeEngine, properties);
    }

    @Override
    public void reset() {
        this.managedService.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.managedService.shutdown(terminate);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.migrationAwareService.prepareReplicationOperation(event);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.beforeMigration(event);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.commitMigration(event);
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.rollbackMigration(event);
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.migrationAwareService.clearPartitionReplica(partitionId);
    }

    @Override
    public Operation getPostJoinOperation() {
        return this.postJoinAwareService.getPostJoinOperation();
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        return this.remoteService.createDistributedObject(objectName);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
        this.remoteService.destroyDistributedObject(objectName);
    }

    @Override
    public void onReplicationEvent(WanReplicationEvent replicationEvent) {
        this.replicationSupportingService.onReplicationEvent(replicationEvent);
    }

    @Override
    public void onPartitionLost(InternalPartitionLostEvent partitionLostEvent) {
        this.partitionAwareService.onPartitionLost(partitionLostEvent);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.splitBrainHandlerService.prepareMergeRunnable();
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, Transaction transaction) {
        return this.transactionalService.createTransactionalObject(name, transaction);
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        this.transactionalService.rollbackTransaction(transactionId);
    }

    public Map<String, LocalMapStats> getStats() {
        return this.statisticsAwareService.getStats();
    }

    @Override
    public String getQuorumName(String name) {
        return this.quorumAwareService.getQuorumName(name);
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.clientAwareService.clientDisconnected(clientUuid);
    }

    public void onRegister(Object service, String serviceName, String topic, EventRegistration registration) {
        EventFilter filter = registration.getFilter();
        if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) {
            return;
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(topic);
        mapContainer.increaseInvalidationListenerCount();
    }

    public void onDeregister(Object service, String serviceName, String topic, EventRegistration registration) {
        EventFilter filter = registration.getFilter();
        if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) {
            return;
        }
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(topic);
        mapContainer.decreaseInvalidationListenerCount();
    }
}

