/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.InternalMapPartitionLostListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapListenerFlagOperator;
import com.hazelcast.map.impl.MapPartitionLostEventFilter;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.event.MapEventPublisherImpl;
import com.hazelcast.map.impl.eviction.ExpirationManager;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.operation.BasePutOperation;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.map.impl.operation.GetOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.operation.MapOperationProviders;
import com.hazelcast.map.impl.operation.MapPartitionDestroyTask;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.MapQueryEngineImpl;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.map.merge.MergePolicyProvider;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.QueryOptimizerFactory;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class MapServiceContextImpl
implements MapServiceContext {
    protected static final long DESTROY_TIMEOUT_SECONDS = 30L;
    protected final NodeEngine nodeEngine;
    protected final PartitionContainer[] partitionContainers;
    protected final ConcurrentMap<String, MapContainer> mapContainers;
    protected final AtomicReference<Collection<Integer>> ownedPartitions;
    protected final ConstructorFunction<String, MapContainer> mapConstructor = new ConstructorFunction<String, MapContainer>(){

        @Override
        public MapContainer createNew(String mapName) {
            MapServiceContext mapServiceContext = MapServiceContextImpl.this.getService().getMapServiceContext();
            Config config = MapServiceContextImpl.this.nodeEngine.getConfig();
            MapConfig mapConfig = config.findMapConfig(mapName);
            return new MapContainer(mapName, mapConfig, mapServiceContext);
        }
    };
    protected final AtomicInteger writeBehindQueueItemCounter = new AtomicInteger(0);
    protected final ExpirationManager expirationManager;
    protected final NearCacheProvider nearCacheProvider;
    protected final LocalMapStatsProvider localMapStatsProvider;
    protected final MergePolicyProvider mergePolicyProvider;
    protected final MapQueryEngine mapQueryEngine;
    protected MapEventPublisher mapEventPublisher;
    protected MapService mapService;
    protected EventService eventService;
    protected MapOperationProviders operationProviders;

    MapServiceContextImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.partitionContainers = this.createPartitionContainers();
        this.mapContainers = new ConcurrentHashMap<String, MapContainer>();
        this.ownedPartitions = new AtomicReference();
        this.expirationManager = new ExpirationManager(this, nodeEngine);
        this.nearCacheProvider = this.createNearCacheProvider();
        this.localMapStatsProvider = this.createLocalMapStatsProvider();
        this.mergePolicyProvider = new MergePolicyProvider(nodeEngine);
        this.mapEventPublisher = this.createMapEventPublisherSupport();
        this.mapQueryEngine = this.createMapQueryEngine();
        this.eventService = nodeEngine.getEventService();
        this.operationProviders = this.createOperationProviders();
    }

    MapOperationProviders createOperationProviders() {
        return new MapOperationProviders(this);
    }

    LocalMapStatsProvider createLocalMapStatsProvider() {
        return new LocalMapStatsProvider(this);
    }

    MapQueryEngineImpl createMapQueryEngine() {
        return new MapQueryEngineImpl(this, QueryOptimizerFactory.newOptimizer(this.nodeEngine.getGroupProperties()));
    }

    NearCacheProvider createNearCacheProvider() {
        return new NearCacheProvider(this);
    }

    PartitionContainer[] createPartitionContainers() {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        return new PartitionContainer[partitionCount];
    }

    MapEventPublisherImpl createMapEventPublisherSupport() {
        return new MapEventPublisherImpl(this);
    }

    @Override
    public MapContainer getMapContainer(String mapName) {
        return ConcurrencyUtil.getOrPutSynchronized(this.mapContainers, mapName, this.mapContainers, this.mapConstructor);
    }

    @Override
    public Map<String, MapContainer> getMapContainers() {
        return this.mapContainers;
    }

    @Override
    public PartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    @Override
    public void initPartitionsContainers() {
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            this.partitionContainers[i] = new PartitionContainer(this.getService(), i);
        }
    }

    @Override
    public void clearPartitionData(int partitionId) {
        PartitionContainer container = this.partitionContainers[partitionId];
        if (container != null) {
            for (RecordStore mapPartition : container.getMaps().values()) {
                mapPartition.clearPartition(false);
            }
            container.getMaps().clear();
        }
    }

    @Override
    public MapService getService() {
        return this.mapService;
    }

    @Override
    public void setService(MapService mapService) {
        this.mapService = mapService;
    }

    @Override
    public void clearPartitions(boolean onShutdown) {
        PartitionContainer[] containers;
        for (PartitionContainer container : containers = this.partitionContainers) {
            if (container == null) continue;
            container.clear(onShutdown);
        }
    }

    @Override
    public void destroyMapStores() {
        for (MapContainer mapContainer : this.mapContainers.values()) {
            MapStoreWrapper store = mapContainer.getMapStoreContext().getMapStoreWrapper();
            if (store == null) continue;
            store.destroy();
        }
    }

    @Override
    public void flushMaps() {
        for (PartitionContainer partitionContainer : this.partitionContainers) {
            for (String mapName : this.mapContainers.keySet()) {
                RecordStore recordStore = partitionContainer.getExistingRecordStore(mapName);
                if (recordStore == null) continue;
                recordStore.flush();
            }
        }
    }

    @Override
    public void destroyMap(String mapName) {
        this.localMapStatsProvider.destroyLocalMapStatsImpl(mapName);
        PartitionContainer[] containers = this.partitionContainers;
        Semaphore semaphore = new Semaphore(0);
        InternalOperationService operationService = (InternalOperationService)this.nodeEngine.getOperationService();
        for (PartitionContainer container : containers) {
            MapPartitionDestroyTask partitionDestroyTask = new MapPartitionDestroyTask(container, mapName, semaphore);
            operationService.execute(partitionDestroyTask);
        }
        try {
            semaphore.tryAcquire(containers.length, 30L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void reset() {
        this.clearPartitions(false);
        this.getNearCacheProvider().reset();
    }

    @Override
    public void shutdown() {
        this.clearPartitions(true);
        this.nearCacheProvider.shutdown();
        this.mapContainers.clear();
    }

    @Override
    public NearCacheProvider getNearCacheProvider() {
        return this.nearCacheProvider;
    }

    @Override
    public RecordStore getRecordStore(int partitionId, String mapName) {
        return this.getPartitionContainer(partitionId).getRecordStore(mapName);
    }

    @Override
    public RecordStore getExistingRecordStore(int partitionId, String mapName) {
        return this.getPartitionContainer(partitionId).getExistingRecordStore(mapName);
    }

    @Override
    public Collection<Integer> getOwnedPartitions() {
        Collection<Integer> partitions = this.ownedPartitions.get();
        if (partitions == null) {
            this.reloadOwnedPartitions();
            partitions = this.ownedPartitions.get();
        }
        return partitions;
    }

    @Override
    public void reloadOwnedPartitions() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        Collection<Integer> partitions = partitionService.getMemberPartitions(this.nodeEngine.getThisAddress());
        if (partitions == null) {
            partitions = Collections.emptySet();
        }
        this.ownedPartitions.set(Collections.unmodifiableSet(new LinkedHashSet<Integer>(partitions)));
    }

    @Override
    public AtomicInteger getWriteBehindQueueItemCounter() {
        return this.writeBehindQueueItemCounter;
    }

    @Override
    public ExpirationManager getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public MergePolicyProvider getMergePolicyProvider() {
        return this.mergePolicyProvider;
    }

    @Override
    public MapEventPublisher getMapEventPublisher() {
        return this.mapEventPublisher;
    }

    @Override
    public MapQueryEngine getMapQueryEngine(String mapName) {
        return this.mapQueryEngine;
    }

    @Override
    public LocalMapStatsProvider getLocalMapStatsProvider() {
        return this.localMapStatsProvider;
    }

    @Override
    public Object toObject(Object data) {
        return this.nodeEngine.toObject(data);
    }

    @Override
    public Data toData(Object object, PartitioningStrategy partitionStrategy) {
        return this.nodeEngine.getSerializationService().toData(object, partitionStrategy);
    }

    @Override
    public Data toData(Object object) {
        return this.nodeEngine.toData(object);
    }

    @Override
    public void interceptAfterGet(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        if (!interceptors.isEmpty()) {
            value = this.toObject(value);
            for (MapInterceptor interceptor : interceptors) {
                interceptor.afterGet(value);
            }
        }
    }

    @Override
    public Object interceptPut(String mapName, Object oldValue, Object newValue) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        Object result = null;
        if (!interceptors.isEmpty()) {
            result = this.toObject(newValue);
            oldValue = this.toObject(oldValue);
            for (MapInterceptor interceptor : interceptors) {
                Object temp = interceptor.interceptPut(oldValue, result);
                if (temp == null) continue;
                result = temp;
            }
        }
        return result == null ? newValue : result;
    }

    @Override
    public void interceptAfterPut(String mapName, Object newValue) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        if (!interceptors.isEmpty()) {
            newValue = this.toObject(newValue);
            for (MapInterceptor interceptor : interceptors) {
                interceptor.afterPut(newValue);
            }
        }
    }

    @Override
    public Object interceptRemove(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        Object result = null;
        if (!interceptors.isEmpty()) {
            result = this.toObject(value);
            for (MapInterceptor interceptor : interceptors) {
                Object temp = interceptor.interceptRemove(result);
                if (temp == null) continue;
                result = temp;
            }
        }
        return result == null ? value : result;
    }

    @Override
    public void interceptAfterRemove(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        if (!interceptors.isEmpty()) {
            for (MapInterceptor interceptor : interceptors) {
                value = this.toObject(value);
                interceptor.afterRemove(value);
            }
        }
    }

    @Override
    public void addInterceptor(String id, String mapName, MapInterceptor interceptor) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        mapContainer.addInterceptor(id, interceptor);
    }

    @Override
    public String generateInterceptorId(String mapName, MapInterceptor interceptor) {
        return interceptor.getClass().getName() + interceptor.hashCode();
    }

    @Override
    public void removeInterceptor(String mapName, String id) {
        this.getMapContainer(mapName).removeInterceptor(id);
    }

    @Override
    public Object interceptGet(String mapName, Object value) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        Object result = null;
        if (!interceptors.isEmpty()) {
            result = this.toObject(value);
            for (MapInterceptor interceptor : interceptors) {
                Object temp = interceptor.interceptGet(result);
                if (temp == null) continue;
                result = temp;
            }
        }
        return result == null ? value : result;
    }

    @Override
    public boolean hasInterceptor(String mapName) {
        List<MapInterceptor> interceptors = this.getMapContainer(mapName).getInterceptors();
        return !interceptors.isEmpty();
    }

    @Override
    public String addLocalEventListener(Object listener, String mapName) {
        EventRegistration registration = this.addListenerInternal(listener, TrueEventFilter.INSTANCE, mapName, true);
        return registration.getId();
    }

    @Override
    public String addLocalEventListener(Object listener, EventFilter eventFilter, String mapName) {
        EventRegistration registration = this.addListenerInternal(listener, eventFilter, mapName, true);
        return registration.getId();
    }

    @Override
    public String addLocalPartitionLostListener(MapPartitionLostListener listener, String mapName) {
        InternalMapPartitionLostListenerAdapter listenerAdapter = new InternalMapPartitionLostListenerAdapter(listener);
        MapPartitionLostEventFilter filter = new MapPartitionLostEventFilter();
        EventRegistration registration = this.eventService.registerLocalListener("hz:impl:mapService", mapName, filter, listenerAdapter);
        return registration.getId();
    }

    @Override
    public String addEventListener(Object listener, EventFilter eventFilter, String mapName) {
        EventRegistration registration = this.addListenerInternal(listener, eventFilter, mapName, false);
        return registration.getId();
    }

    @Override
    public String addPartitionLostListener(MapPartitionLostListener listener, String mapName) {
        InternalMapPartitionLostListenerAdapter listenerAdapter = new InternalMapPartitionLostListenerAdapter(listener);
        MapPartitionLostEventFilter filter = new MapPartitionLostEventFilter();
        EventRegistration registration = this.eventService.registerListener("hz:impl:mapService", mapName, filter, listenerAdapter);
        return registration.getId();
    }

    private EventRegistration addListenerInternal(Object listener, EventFilter filter, String mapName, boolean local) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        if (!(filter instanceof EventListenerFilter)) {
            int enabledListeners = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
            filter = new EventListenerFilter(enabledListeners, filter);
        }
        if (local) {
            return this.eventService.registerLocalListener("hz:impl:mapService", mapName, filter, listenerAdaptor);
        }
        return this.eventService.registerListener("hz:impl:mapService", mapName, filter, listenerAdaptor);
    }

    @Override
    public boolean removeEventListener(String mapName, String registrationId) {
        return this.eventService.deregisterListener("hz:impl:mapService", mapName, registrationId);
    }

    @Override
    public boolean removePartitionLostListener(String mapName, String registrationId) {
        return this.eventService.deregisterListener("hz:impl:mapService", mapName, registrationId);
    }

    @Override
    public MapOperationProvider getMapOperationProvider(String name) {
        return this.operationProviders.getOperationProvider(name);
    }

    @Override
    public Extractors getExtractors(String mapName) {
        MapContainer mapContainer = this.getMapContainer(mapName);
        return mapContainer.getExtractors();
    }

    @Override
    public void incrementOperationStats(long startTime, LocalMapStatsImpl localMapStats, String mapName, Operation operation) {
        long duration = System.currentTimeMillis() - startTime;
        if (operation instanceof BasePutOperation) {
            localMapStats.incrementPuts(duration);
        } else if (operation instanceof BaseRemoveOperation) {
            localMapStats.incrementRemoves(duration);
        } else if (operation instanceof GetOperation) {
            localMapStats.incrementGets(duration);
        }
    }

    @Override
    public RecordStore createRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader) {
        ILogger logger = this.nodeEngine.getLogger(DefaultRecordStore.class);
        return new DefaultRecordStore(mapContainer, partitionId, keyLoader, logger);
    }
}

