/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.PutBackupOperation;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.MutatingOperation;

public abstract class BasePutOperation
extends LockAwareOperation
implements BackupAwareOperation,
MutatingOperation {
    protected transient Data dataOldValue;
    protected transient EntryEventType eventType;
    protected transient boolean putTransient;

    public BasePutOperation(String name, Data dataKey, Data value) {
        super(name, dataKey, value, -1L);
    }

    public BasePutOperation(String name, Data dataKey, Data value, long ttl) {
        super(name, dataKey, value, ttl);
    }

    public BasePutOperation() {
    }

    @Override
    public void afterRun() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapServiceContext.interceptAfterPut(this.name, this.dataValue);
        this.publishEvent(mapEventPublisher);
        this.invalidateNearCache(this.dataKey);
        this.publishWANReplicationEvent(mapServiceContext, mapEventPublisher);
        this.evict();
    }

    private void publishEvent(MapEventPublisher mapEventPublisher) {
        this.eventType = this.getEventType();
        Data value = this.dataValue;
        if (this.recordStore.getMapDataStore().isPostProcessingMapStore()) {
            Object record = this.recordStore.getRecord(this.dataKey);
            value = record.getValue();
        }
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, this.dataOldValue, value);
    }

    private void publishWANReplicationEvent(MapServiceContext mapServiceContext, MapEventPublisher mapEventPublisher) {
        if (!this.mapContainer.isWanReplicationEnabled()) {
            return;
        }
        Object record = this.recordStore.getRecord(this.dataKey);
        if (record == null) {
            return;
        }
        Data valueConvertedData = mapServiceContext.toData(this.dataValue);
        EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(this.dataKey, valueConvertedData, record);
        mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
    }

    private EntryEventType getEventType() {
        if (this.eventType == null) {
            this.eventType = this.dataOldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        }
        return this.eventType;
    }

    @Override
    public boolean shouldBackup() {
        Object record = this.recordStore.getRecord(this.dataKey);
        return record != null;
    }

    @Override
    public Operation getBackupOperation() {
        Object record = this.recordStore.getRecord(this.dataKey);
        RecordInfo replicationInfo = Records.buildRecordInfo(record);
        MapDataStore<Data, Object> mapDataStore = this.recordStore.getMapDataStore();
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        if (mapServiceContext.hasInterceptor(this.name) || mapDataStore.isPostProcessingMapStore()) {
            this.dataValue = mapServiceContext.toData(record.getValue());
        }
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, replicationInfo, this.putTransient);
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }
}

