/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.IterationType;
import java.io.IOException;

public class QueryOperation
extends MapOperation
implements ReadonlyOperation {
    private Predicate predicate;
    private QueryResult result;
    private IterationType iterationType;

    public QueryOperation() {
    }

    public QueryOperation(String mapName, Predicate predicate, IterationType iterationType) {
        super(mapName);
        this.predicate = predicate;
        this.iterationType = iterationType;
    }

    @Override
    public void run() throws Exception {
        MapQueryEngine queryEngine = this.mapService.getMapServiceContext().getMapQueryEngine(this.name);
        this.result = queryEngine.queryLocalPartitions(this.name, this.predicate, this.iterationType);
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
        out.writeObject(this.predicate);
        out.writeByte(this.iterationType.getId());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
        this.predicate = (Predicate)in.readObject();
        this.iterationType = IterationType.getById(in.readByte());
    }
}

