/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.ringbuffer.impl.client.RingbufferPortableHook;
import java.io.IOException;

public abstract class RingbufferRequest
extends PartitionClientRequest
implements Portable {
    protected String name;

    protected RingbufferRequest() {
    }

    protected RingbufferRequest(String name) {
        this.name = name;
    }

    @Override
    protected int getPartition() {
        String partitionKey = StringPartitioningStrategy.getPartitionKey(this.name);
        return this.getClientEngine().getPartitionService().getPartitionId(partitionKey);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:ringbufferService";
    }

    @Override
    public int getFactoryId() {
        return RingbufferPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

