/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.xa.operations.ClearRemoteTransactionOperation;
import java.io.IOException;
import java.security.Permission;

public class ClearRemoteTransactionRequest
extends CallableClientRequest {
    private static final int TRY_COUNT = 100;
    Data xidData;

    public ClearRemoteTransactionRequest() {
    }

    public ClearRemoteTransactionRequest(Data xidData) {
        this.xidData = xidData;
    }

    public Object call() throws Exception {
        int partitionId = this.getClientEngine().getPartitionService().getPartitionId(this.xidData);
        ClientEndpoint endpoint = this.getEndpoint();
        ClearRemoteTransactionOperation op = new ClearRemoteTransactionOperation(this.xidData);
        op.setCallerUuid(endpoint.getUuid());
        InvocationBuilder builder = this.operationService.createInvocationBuilder(this.getServiceName(), (Operation)op, partitionId).setTryCount(100).setResultDeserialized(false);
        builder.invoke();
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.xidData);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.xidData = in.readData();
    }
}

