/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.TimeUnit;

public final class ExpirationTimeSetter {
    private ExpirationTimeSetter() {
    }

    public static void setExpirationTime(Record record, long maxIdleMillis) {
        long expirationTime = ExpirationTimeSetter.calculateExpirationTime(record, maxIdleMillis);
        record.setExpirationTime(expirationTime);
    }

    private static long calculateExpirationTime(Record record, long maxIdleMillis) {
        long ttl = ExpirationTimeSetter.checkedTime(record.getTtl());
        long ttlExpirationTime = ExpirationTimeSetter.sumForExpiration(ttl, ExpirationTimeSetter.getLifeStartTime(record));
        maxIdleMillis = ExpirationTimeSetter.checkedTime(maxIdleMillis);
        long idleExpirationTime = ExpirationTimeSetter.sumForExpiration(maxIdleMillis, ExpirationTimeSetter.getIdlenessStartTime(record));
        return Math.min(ttlExpirationTime, idleExpirationTime);
    }

    public static long getIdlenessStartTime(Record record) {
        long lastAccessTime = record.getLastAccessTime();
        return lastAccessTime == 0L ? record.getCreationTime() : lastAccessTime;
    }

    public static long getLifeStartTime(Record record) {
        long lastUpdateTime = record.getLastUpdateTime();
        return lastUpdateTime == 0L ? record.getCreationTime() : lastUpdateTime;
    }

    private static long checkedTime(long time) {
        return time <= 0L ? Long.MAX_VALUE : time;
    }

    private static long sumForExpiration(long criteriaTime, long now) {
        if (criteriaTime < 0L || now < 0L) {
            throw new IllegalArgumentException("Parameters can not have negative values");
        }
        if (criteriaTime == 0L) {
            return Long.MAX_VALUE;
        }
        long expirationTime = criteriaTime + now;
        if (expirationTime < 0L) {
            return Long.MAX_VALUE;
        }
        return expirationTime;
    }

    public static long pickTTL(long ttlMillis, long ttlMillisFromConfig) {
        if (ttlMillis < 0L && ttlMillisFromConfig > 0L) {
            return ttlMillisFromConfig;
        }
        if (ttlMillis > 0L) {
            return ttlMillis;
        }
        return 0L;
    }

    public static long calculateMaxIdleMillis(MapConfig mapConfig) {
        int maxIdleSeconds = mapConfig.getMaxIdleSeconds();
        if (maxIdleSeconds == 0) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.SECONDS.toMillis(maxIdleSeconds);
    }

    public static long calculateTTLMillis(MapConfig mapConfig) {
        int timeToLiveSeconds = mapConfig.getTimeToLiveSeconds();
        if (timeToLiveSeconds == 0) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.SECONDS.toMillis(timeToLiveSeconds);
    }

    public static void updateExpiryTime(Record record, long ttl, MapConfig mapConfig) {
        if (ttl < 0L) {
            ttl = record.getTtl();
        }
        ttl = ExpirationTimeSetter.checkedTime(ttl);
        record.setTtl(ttl);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(mapConfig);
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
    }

    public static long calculateExpirationWithDelay(long timeInMillis, long delayMillis, boolean backup) {
        Preconditions.checkNotNegative(timeInMillis, "timeInMillis can't be negative");
        if (backup) {
            long delayedTime = timeInMillis + delayMillis;
            if (delayedTime < 0L) {
                return Long.MAX_VALUE;
            }
            return delayedTime;
        }
        return timeInMillis;
    }
}

