/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.map.impl.nearcache.KeyStateMarkerImpl;
import com.hazelcast.monitor.NearCacheStats;

public final class StaleReadPreventerNearCacheWrapper
implements NearCache {
    private final NearCache nearCache;
    private final KeyStateMarker keyStateMarker;

    private StaleReadPreventerNearCacheWrapper(NearCache nearCache, int markerCount) {
        this.nearCache = nearCache;
        this.keyStateMarker = new KeyStateMarkerImpl(markerCount);
    }

    public static NearCache wrapAsStaleReadPreventerNearCache(NearCache nearCache, int markerCount) {
        return new StaleReadPreventerNearCacheWrapper(nearCache, markerCount);
    }

    @Override
    public String getName() {
        return this.nearCache.getName();
    }

    public Object get(Object key) {
        return this.nearCache.get(key);
    }

    public void put(Object key, Object value) {
        this.nearCache.put(key, value);
    }

    public boolean remove(Object key) {
        this.keyStateMarker.tryRemove(key);
        return this.nearCache.remove(key);
    }

    @Override
    public boolean isInvalidateOnChange() {
        return this.nearCache.isInvalidateOnChange();
    }

    @Override
    public void clear() {
        this.keyStateMarker.init();
        this.nearCache.clear();
    }

    @Override
    public void destroy() {
        this.keyStateMarker.init();
        this.nearCache.destroy();
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.nearCache.getInMemoryFormat();
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        return this.nearCache.getNearCacheStats();
    }

    @Override
    public Object selectToSave(Object ... candidates) {
        return this.nearCache.selectToSave(candidates);
    }

    @Override
    public int size() {
        return this.nearCache.size();
    }

    public KeyStateMarker getKeyStateMarker() {
        return this.keyStateMarker;
    }
}

