/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

@PrivateApi
public class BasicSSLContextFactory
implements SSLContextFactory {
    private static final String JAVA_NET_SSL_PREFIX = "javax.net.ssl.";
    private SSLContext sslContext;

    @Override
    public void init(Properties properties) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyStore ts = KeyStore.getInstance("JKS");
        String keyStorePassword = BasicSSLContextFactory.getProperty(properties, "keyStorePassword");
        String keyStore = BasicSSLContextFactory.getProperty(properties, "keyStore");
        String trustStore = BasicSSLContextFactory.getProperty(properties, "trustStore", keyStore);
        String trustStorePassword = BasicSSLContextFactory.getProperty(properties, "trustStorePassword", keyStorePassword);
        String keyManagerAlgorithm = properties.getProperty("keyManagerAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
        String trustManagerAlgorithm = properties.getProperty("trustManagerAlgorithm", TrustManagerFactory.getDefaultAlgorithm());
        String protocol = properties.getProperty("protocol", "TLS");
        KeyManager[] keyManagers = null;
        if (keyStore != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            char[] passPhrase = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
            this.loadKeyStore(ks, passPhrase, keyStore);
            kmf.init(ks, passPhrase);
            keyManagers = kmf.getKeyManagers();
        }
        TrustManager[] trustManagers = null;
        if (trustStore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
            char[] passPhrase = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
            this.loadKeyStore(ts, passPhrase, trustStore);
            tmf.init(ts);
            trustManagers = tmf.getTrustManagers();
        }
        this.sslContext = SSLContext.getInstance(protocol);
        this.sslContext.init(keyManagers, trustManagers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyStore(KeyStore ks, char[] passPhrase, String keyStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream in = new FileInputStream(keyStoreFile);
        try {
            ks.load(in, passPhrase);
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    private static String getProperty(Properties properties, String property) {
        String value = properties.getProperty(property);
        if (value == null) {
            value = properties.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        if (value == null) {
            value = System.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        return value;
    }

    private static String getProperty(Properties properties, String property, String defaultValue) {
        String value = BasicSSLContextFactory.getProperty(properties, property);
        return value != null ? value : defaultValue;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }
}

