/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.nonblocking;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.nio.tcp.nonblocking.MigratableHandler;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThreadingModel;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.SelectionKey;

public abstract class AbstractHandler
implements MigratableHandler {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final TcpIpConnection connection;
    protected final TcpIpConnectionManager connectionManager;
    protected final IOService ioService;
    protected NonBlockingIOThread ioThread;
    protected SelectionKey selectionKey;
    private final int initialOps;
    @Probe
    private volatile int ioThreadId;
    @Probe
    private SwCounter migrationCount = SwCounter.newSwCounter();

    public AbstractHandler(TcpIpConnection connection, NonBlockingIOThread ioThread, int initialOps) {
        this.connection = connection;
        this.ioThread = ioThread;
        this.ioThreadId = ioThread.id;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.ioService = this.connectionManager.getIoService();
        this.logger = this.ioService.getLogger(this.getClass().getName());
        this.initialOps = initialOps;
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsInterested() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.interestOps();
    }

    @Probe(level=ProbeLevel.DEBUG)
    private long opsReady() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.readyOps();
    }

    @Override
    public NonBlockingIOThread getOwner() {
        return this.ioThread;
    }

    protected SelectionKey getSelectionKey() throws IOException {
        if (this.selectionKey == null) {
            this.selectionKey = this.socketChannel.register(this.ioThread.getSelector(), this.initialOps, this);
        }
        return this.selectionKey;
    }

    final void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    final void registerOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() | operation);
    }

    final void unregisterOp(int operation) throws IOException {
        SelectionKey selectionKey = this.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() & ~operation);
    }

    @Override
    public void onFailure(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            this.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        if (e instanceof EOFException) {
            this.connection.close("Connection closed by the other side", e);
        } else {
            this.connection.close("Exception in " + this.getClass().getSimpleName(), e);
        }
    }

    void startMigration(final NonBlockingIOThread newOwner) throws IOException {
        assert (this.ioThread == Thread.currentThread()) : "startMigration can only run on the owning NonBlockingIOThread";
        assert (this.ioThread != newOwner) : "newOwner can't be the same as the existing owner";
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.migrationCount.inc();
        this.unregisterOp(this.initialOps);
        this.ioThread = newOwner;
        this.ioThreadId = this.ioThread.id;
        this.selectionKey.cancel();
        this.selectionKey = null;
        newOwner.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractHandler.this.completeMigration(newOwner);
                }
                catch (Throwable t) {
                    AbstractHandler.this.onFailure(t);
                }
            }
        });
    }

    private void completeMigration(NonBlockingIOThread newOwner) throws IOException {
        assert (this.ioThread == newOwner);
        NonBlockingIOThreadingModel threadingModel = (NonBlockingIOThreadingModel)this.connection.getConnectionManager().getIoThreadingModel();
        threadingModel.getIOBalancer().signalMigrationComplete();
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.selectionKey = this.getSelectionKey();
        this.registerOp(this.initialOps);
    }
}

