/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.nio.Address;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LiveOperations {
    private final Address localAddress;
    private final Map<Address, List<Long>> callIdsByMember = new HashMap<Address, List<Long>>();

    public LiveOperations(Address localAddress) {
        this.localAddress = Preconditions.checkNotNull(localAddress, "local address can't be null");
    }

    public void add(Address address, long callId) {
        List<Long> callIds;
        if (callId == 0L) {
            return;
        }
        if (address == null) {
            address = this.localAddress;
        }
        if ((callIds = this.callIdsByMember.get(address)) == null) {
            callIds = new ArrayList<Long>();
            this.callIdsByMember.put(address, callIds);
        }
        callIds.add(callId);
    }

    public Set<Address> addresses() {
        return this.callIdsByMember.keySet();
    }

    public long[] callIds(Address address) {
        List<Long> callIdList = this.callIdsByMember.get(address);
        if (callIdList == null) {
            throw new IllegalArgumentException("unknown address");
        }
        long[] array = new long[callIdList.size()];
        for (int k = 0; k < array.length; ++k) {
            array[k] = callIdList.get(k);
        }
        return array;
    }

    public void clear() {
        this.callIdsByMember.clear();
    }

    public void initMember(Address address) {
        this.callIdsByMember.put(address, new LinkedList());
    }
}

