/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.collection.MPSCQueue;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.util.concurrent.BusySpinIdleStrategy;
import com.hazelcast.util.concurrent.IdleStrategy;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class AsyncResponseHandler
implements PacketHandler,
MetricsProvider {
    public static final HazelcastProperty IDLE_STRATEGY = new HazelcastProperty("hazelcast.operation.responsequeue.idlestrategy", "block");
    private static final long IDLE_MAX_SPINS = 20L;
    private static final long IDLE_MAX_YIELDS = 50L;
    private static final long IDLE_MIN_PARK_NS = TimeUnit.NANOSECONDS.toNanos(1L);
    private static final long IDLE_MAX_PARK_NS = TimeUnit.MICROSECONDS.toNanos(100L);
    final ResponseThread responseThread;
    private final ILogger logger;

    AsyncResponseHandler(HazelcastThreadGroup threadGroup, ILogger logger, PacketHandler responsePacketHandler, HazelcastProperties properties) {
        this.logger = logger;
        this.responseThread = new ResponseThread(threadGroup, responsePacketHandler, properties);
    }

    @Probe(name="responseQueueSize", level=ProbeLevel.MANDATORY)
    public int getQueueSize() {
        return this.responseThread.responseQueue.size();
    }

    @Override
    public void handle(Packet packet) {
        Preconditions.checkNotNull(packet, "packet can't be null");
        Preconditions.checkTrue(packet.isFlagSet(1), "FLAG_OP should be set");
        Preconditions.checkTrue(packet.isFlagSet(2), "FLAG_RESPONSE should be set");
        this.responseThread.responseQueue.add(packet);
    }

    @Override
    public void provideMetrics(MetricsRegistry metricsRegistry) {
        metricsRegistry.scanAndRegister(this, "operation");
    }

    public void start() {
        this.responseThread.start();
    }

    public void shutdown() {
        this.responseThread.shutdown();
    }

    public static IdleStrategy getIdleStrategy(HazelcastProperties properties, HazelcastProperty property) {
        String idleStrategyString = properties.getString(property);
        if ("block".equals(idleStrategyString)) {
            return null;
        }
        if ("backoff".equals(idleStrategyString)) {
            return new BackoffIdleStrategy(20L, 50L, IDLE_MIN_PARK_NS, IDLE_MAX_PARK_NS);
        }
        if ("busyspin".equals(idleStrategyString)) {
            return new BusySpinIdleStrategy();
        }
        throw new IllegalStateException("Unrecognized " + property.getName() + " value=" + idleStrategyString);
    }

    final class ResponseThread
    extends Thread
    implements OperationHostileThread {
        private final BlockingQueue<Packet> responseQueue;
        private final PacketHandler responsePacketHandler;
        private volatile boolean shutdown;

        private ResponseThread(HazelcastThreadGroup threadGroup, PacketHandler responsePacketHandler, HazelcastProperties properties) {
            super(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix("response"));
            this.setContextClassLoader(threadGroup.getClassLoader());
            this.responsePacketHandler = responsePacketHandler;
            this.responseQueue = new MPSCQueue<Packet>(this, AsyncResponseHandler.getIdleStrategy(properties, IDLE_STRATEGY));
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
                AsyncResponseHandler.this.logger.severe(t);
            }
        }

        private void doRun() throws InterruptedException {
            while (!this.shutdown) {
                Packet response = this.responseQueue.take();
                try {
                    this.responsePacketHandler.handle(response);
                }
                catch (Throwable e) {
                    OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(e);
                    AsyncResponseHandler.this.logger.severe("Failed to process response: " + response + " on:" + this.getName(), e);
                }
            }
        }

        private void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }
    }
}

