/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.logging.Logger;
import com.hazelcast.nio.UnsafeHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public final class JVMUtil {
    public static final int REFERENCE_COST_IN_BYTES = JVMUtil.is32bitJVM() || JVMUtil.isCompressedOops() ? 4 : 8;

    private JVMUtil() {
    }

    static boolean is32bitJVM() {
        String architecture = System.getProperty("sun.arch.data.model");
        return architecture != null && architecture.equals("32");
    }

    static boolean isCompressedOops() {
        Boolean enabled = JVMUtil.isHotSpotCompressedOopsOrNull();
        if (enabled != null) {
            return enabled;
        }
        enabled = JVMUtil.isObjectLayoutCompressedOopsOrNull();
        if (enabled != null) {
            return enabled;
        }
        Logger.getLogger(JVMUtil.class).info("Could not determine memory cost of reference; setting to default of 4 bytes.");
        return true;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    static Boolean isHotSpotCompressedOopsOrNull() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName mbean = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            Object[] objects = new Object[]{"UseCompressedOops"};
            String[] strings = new String[]{"java.lang.String"};
            String operation = "getVMOption";
            CompositeDataSupport compressedOopsValue = (CompositeDataSupport)server.invoke(mbean, operation, objects, strings);
            return Boolean.valueOf(compressedOopsValue.get("value").toString());
        }
        catch (Exception e) {
            Logger.getLogger(JVMUtil.class).fine("Failed to read HotSpot specific configuration: " + e.getMessage());
            return null;
        }
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    static Boolean isObjectLayoutCompressedOopsOrNull() {
        int oopSize;
        if (!UnsafeHelper.UNSAFE_AVAILABLE) {
            return null;
        }
        try {
            long off1 = UnsafeHelper.UNSAFE.objectFieldOffset(CompressedOopsClass.class.getField("obj1"));
            long off2 = UnsafeHelper.UNSAFE.objectFieldOffset(CompressedOopsClass.class.getField("obj2"));
            oopSize = (int)Math.abs(off2 - off1);
        }
        catch (Exception e) {
            Logger.getLogger(JVMUtil.class).fine("Could not determine cost of reference using field offsets: " + e.getMessage());
            return null;
        }
        return oopSize != UnsafeHelper.UNSAFE.addressSize();
    }

    private static class CompressedOopsClass {
        public Object obj1;
        public Object obj2;

        private CompressedOopsClass() {
        }
    }
}

