/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.RetryOnFailure;
import com.jcabi.log.Logger;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class Repeater {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ Repeater ajc$perSingletonInstance;

    @Around(value="execution(* * (..)) && @annotation(com.jcabi.aspects.RetryOnFailure)")
    public Object wrap(ProceedingJoinPoint point) throws Throwable {
        RetryOnFailure rof = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod().getAnnotation(RetryOnFailure.class);
        int attempt = 0;
        while (true) {
            long start = System.nanoTime();
            try {
                return point.proceed();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw ex;
            }
            catch (Throwable ex) {
                ++attempt;
                if (rof.verbose()) {
                    Logger.warn((Object)this, (String)"attempt #%d of %d failed in %[nano]s: %[exception]s", (Object[])new Object[]{attempt, rof.attempts(), System.nanoTime() - start, ex});
                } else {
                    Logger.warn((Object)this, (String)"attempt #%d/%d failed in %[nano]s: %s", (Object[])new Object[]{attempt, rof.attempts(), System.nanoTime() - start, ex.getMessage()});
                }
                if (attempt >= rof.attempts()) {
                    throw ex;
                }
                if (rof.delay() <= 0L) continue;
                TimeUnit.MILLISECONDS.sleep(rof.delay() * (long)attempt);
                continue;
            }
            break;
        }
    }

    public static Repeater aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.Repeater", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            Repeater.ajc$perSingletonInstance = new Repeater();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

