/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.PreFormatter;
import org.slf4j.LoggerFactory;

public final class Logger {
    private Logger() {
    }

    public static String format(String fmt, Object ... args) {
        String result;
        if (args.length == 0) {
            result = fmt;
        } else {
            PreFormatter pre = new PreFormatter(fmt, args);
            result = String.format(pre.getFormat(), pre.getArguments());
        }
        return result;
    }

    public static void trace(Object source, String msg, Object ... args) {
        if (Logger.isTraceEnabled(source)) {
            Logger.logger(source).trace(Logger.format(msg, args));
        }
    }

    public static void debug(Object source, String msg, Object ... args) {
        if (Logger.isDebugEnabled(source)) {
            Logger.logger(source).debug(Logger.format(msg, args));
        }
    }

    public static void info(Object source, String msg, Object ... args) {
        if (Logger.isInfoEnabled(source)) {
            Logger.logger(source).info(Logger.format(msg, args));
        }
    }

    public static void warn(Object source, String msg, Object ... args) {
        if (Logger.isWarnEnabled(source)) {
            Logger.logger(source).warn(Logger.format(msg, args));
        }
    }

    public static void error(Object source, String msg, Object ... args) {
        Logger.logger(source).error(Logger.format(msg, args));
    }

    public static boolean isTraceEnabled(Object source) {
        return Logger.logger(source).isTraceEnabled();
    }

    public static boolean isDebugEnabled(Object source) {
        return Logger.logger(source).isDebugEnabled();
    }

    public static boolean isInfoEnabled(Object source) {
        return Logger.logger(source).isInfoEnabled();
    }

    public static boolean isWarnEnabled(Object source) {
        return Logger.logger(source).isWarnEnabled();
    }

    private static org.slf4j.Logger logger(Object source) {
        org.slf4j.Logger logger = source instanceof Class ? LoggerFactory.getLogger((Class)((Class)source)) : LoggerFactory.getLogger(source.getClass());
        return logger;
    }
}

