/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;

final class MsDecor
implements Formattable {
    private final transient Double millis;

    public MsDecor(Long msec) {
        this.millis = msec == null ? null : Double.valueOf(msec.longValue());
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.millis == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder format = new StringBuilder();
            format.append('%');
            if ((flags & 1) == 1) {
                format.append('-');
            }
            if (width > 0) {
                format.append(Integer.toString(width));
            }
            if ((flags & 2) == 2) {
                format.append('S');
            } else {
                format.append('s');
            }
            formatter.format(format.toString(), this.toText(precision));
        }
    }

    private String toText(int precision) {
        String title;
        double number;
        if (this.millis < 1000.0) {
            number = this.millis;
            title = "ms";
        } else if (this.millis < 60000.0) {
            number = this.millis / 1000.0;
            title = "s";
        } else {
            number = this.millis / 60000.0;
            title = "min";
        }
        String format = precision >= 0 ? String.format("%%.%df%%s", precision) : String.format("%%.0f%%s", new Object[0]);
        return String.format(format, number, title);
    }
}

