/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.DecorException;
import com.jcabi.log.DecorsManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PreFormatter {
    private transient String format;
    private transient List<Object> arguments;

    public PreFormatter(String fmt, Object ... args) {
        this.process(fmt, args);
    }

    public String getFormat() {
        return this.format;
    }

    public Object[] getArguments() {
        return this.arguments.toArray(new Object[0]);
    }

    private void process(String fmt, Object[] args) {
        this.arguments = new CopyOnWriteArrayList<Object>();
        StringBuffer buf = new StringBuffer();
        Pattern pattern = Pattern.compile("%(?:\\d+\\$)?(\\[([A-Za-z\\-\\.0-9]+)\\])?[\\+\\-]?(?:\\d*(?:\\.\\d+)?)?[a-zA-Z%]");
        Matcher matcher = pattern.matcher(fmt);
        int pos = 0;
        while (matcher.find()) {
            String decor = matcher.group(2);
            if (decor == null) {
                matcher.appendReplacement(buf, Matcher.quoteReplacement(matcher.group()));
                this.arguments.add(args[pos]);
            } else {
                matcher.appendReplacement(buf, Matcher.quoteReplacement(matcher.group().replace(matcher.group(1), "")));
                try {
                    this.arguments.add(DecorsManager.decor(decor, args[pos]));
                }
                catch (DecorException ex) {
                    this.arguments.add(String.format("[%s]", ex.getMessage()));
                }
            }
            ++pos;
        }
        matcher.appendTail(buf);
        this.format = buf.toString();
    }
}

