/*
 * Decompiled with CFR 0.152.
 */
package urlshortener;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;
import retrofit.Server;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Query;
import urlshortener.UrlShortener;

final class BitlyUrlShortener
implements UrlShortener {
    private static final Logger logger = LoggerFactory.getLogger(BitlyUrlShortener.class);
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static final RestAdapter restAdapter = new RestAdapter.Builder().setServer(new Server("https://api-ssl.bitly.com")).setConverter((Converter)new GsonConverter(gson)).build();
    private static final BitlyService bitly = (BitlyService)restAdapter.create(BitlyService.class);
    private static final int HTTP_OK = 200;
    private final String accessToken;

    BitlyUrlShortener(String accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public URI shorten(URI longUrl) {
        ShortenResponse response = bitly.shorten(this.accessToken, longUrl);
        if (response.statusCode != 200) {
            logger.debug("Request to shorten URL {} failed with code {}", (Object)longUrl, (Object)response.statusCode);
            return longUrl;
        }
        return response.data.url;
    }

    private static final class ShortenResponse {
        private Data data;
        private int statusCode;

        ShortenResponse() {
        }

        static final class Data {
            private URI url;

            Data() {
            }
        }
    }

    static interface BitlyService {
        @GET(value="/v3/shorten")
        public ShortenResponse shorten(@Query(value="access_token") String var1, @Query(value="longUrl") URI var2);
    }
}

