/*
 * Decompiled with CFR 0.152.
 */
package urlshortener;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.Server;
import retrofit.http.Body;
import retrofit.http.POST;
import retrofit.http.Query;
import urlshortener.UrlShortener;

final class GoogleUrlShortener
implements UrlShortener {
    private static final Logger logger = LoggerFactory.getLogger(GoogleUrlShortener.class);
    private static final RestAdapter restAdapter = new RestAdapter.Builder().setServer(new Server("https://www.googleapis.com/urlshortener")).build();
    private static final GoogleService google = (GoogleService)restAdapter.create(GoogleService.class);
    private final String apiKey;

    GoogleUrlShortener(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public URI shorten(URI longUrl) {
        try {
            return google.shorten(this.apiKey, new Payload(longUrl)).id;
        }
        catch (RetrofitError e) {
            ErrorPayload error = ((ErrorResponse)e.getBodyAs(ErrorResponse.class)).error;
            logger.debug("Request to shorten {} failed with {}", (Object)longUrl, (Object)error.message);
            return longUrl;
        }
    }

    private static final class ErrorPayload {
        private int code;
        private String message;

        ErrorPayload() {
        }
    }

    private static final class ErrorResponse {
        private ErrorPayload error;

        ErrorResponse() {
        }
    }

    private static final class Payload {
        private URI id = null;
        private URI longUrl;

        Payload(URI longUrl) {
            this.longUrl = longUrl;
        }
    }

    static interface GoogleService {
        @POST(value="/v1/url")
        public Payload shorten(@Query(value="key") String var1, @Body Payload var2);
    }
}

