/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.cpp;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.bridj.ann.Template;

public class CPPType
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Type rawType;
    private final Object[] templateParameters;

    public CPPType(Type ownerType, Type rawType, Object ... templateParameters) {
        this.ownerType = ownerType;
        this.actualTypeArguments = CPPType.getTypes(templateParameters);
        this.rawType = rawType;
        this.templateParameters = templateParameters;
    }

    public CPPType(Type rawType, Object ... templateParameters) {
        this(null, rawType, templateParameters);
    }

    private static Type[] getTypes(Object[] objects) {
        ArrayList<Type> ret = new ArrayList<Type>(objects.length);
        int i = 0;
        int n = objects.length;
        while (i < n) {
            Object o = objects[i];
            if (o instanceof Type) {
                ret.add((Type)o);
            }
            ++i;
        }
        return ret.toArray(new Type[ret.size()]);
    }

    static Object[] cons(Class firstClass, Object ... flattenedClassesAndParams) {
        Object[] a = new Object[flattenedClassesAndParams.length + 1];
        a[0] = firstClass;
        System.arraycopy(flattenedClassesAndParams, 0, a, 1, flattenedClassesAndParams.length);
        return a;
    }

    public static Type getCPPType(Object ... flattenedClassesAndParams) {
        int[] position = new int[1];
        Type t = CPPType.parseCPPType(flattenedClassesAndParams, position);
        if (position[0] < flattenedClassesAndParams.length) {
            CPPType.parseError("Unexpected trailing parameters", flattenedClassesAndParams, position);
        }
        return t;
    }

    static void parseError(String message, Object[] flattenedClassesAndParams, int[] position) {
        throw new IllegalArgumentException("Error while parsing C++ type in " + Arrays.asList(flattenedClassesAndParams) + " at offset " + position[0] + " : " + message);
    }

    static void notEOF(String message, Object[] flattenedClassesAndParams, int[] position) {
        if (position[0] >= flattenedClassesAndParams.length) {
            throw new IllegalArgumentException("EOF while parsing C++ type in " + Arrays.asList(flattenedClassesAndParams) + " at offset " + position[0] + " : " + message);
        }
    }

    static Type parseCPPType(Object[] flattenedClassesAndParams, int[] position) {
        CPPType.notEOF("expecting class", flattenedClassesAndParams, position);
        Object oc = flattenedClassesAndParams[position[0]];
        if (!(oc instanceof Class)) {
            CPPType.parseError("expected class", flattenedClassesAndParams, position);
        }
        Class c = (Class)oc;
        position[0] = position[0] + 1;
        Template t = c.getAnnotation(Template.class);
        Class<?>[] paramTypes = t == null ? null : t.value();
        int nParams = paramTypes == null ? 0 : paramTypes.length;
        Object[] params = new Object[nParams];
        int iParam = 0;
        while (iParam < nParams) {
            CPPType.notEOF("expecting param " + iParam + " for template " + c.getName(), flattenedClassesAndParams, position);
            Object param = flattenedClassesAndParams[position[0]];
            Class<?> paramType = paramTypes[iParam];
            if (paramType.equals(Class.class) && param.getClass().equals(Class.class)) {
                param = CPPType.parseCPPType(flattenedClassesAndParams, position);
            } else {
                if (!paramType.isInstance(param)) {
                    CPPType.parseError("bad type for template param " + iParam + " : expected a " + paramType + ", got " + param, flattenedClassesAndParams, position);
                }
                position[0] = position[0] + 1;
            }
            params[iParam] = param;
            ++iParam;
        }
        return nParams == 0 ? c : new CPPType((Type)c, params);
    }

    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    public Type getOwnerType() {
        return this.ownerType;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public Object[] getTemplateParameters() {
        return (Object[])this.templateParameters.clone();
    }

    public int hashCode() {
        int h = this.getRawType().hashCode();
        if (this.getOwnerType() != null) {
            h ^= this.getOwnerType().hashCode();
        }
        int i = 0;
        int n = this.templateParameters.length;
        while (i < n) {
            h ^= this.templateParameters[i].hashCode();
            ++i;
        }
        return h;
    }

    static boolean eq(Object a, Object b) {
        if (a == null != (b == null)) {
            return false;
        }
        return a == null || a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CPPType)) {
            return false;
        }
        CPPType t = (CPPType)o;
        if (!CPPType.eq(this.getRawType(), t.getRawType())) {
            return false;
        }
        if (!CPPType.eq(this.getOwnerType(), t.getOwnerType())) {
            return false;
        }
        Object[] tp = t.templateParameters;
        if (this.templateParameters.length != tp.length) {
            return false;
        }
        int i = 0;
        int n = this.templateParameters.length;
        while (i < n) {
            if (!CPPType.eq(this.templateParameters[i], tp[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getOwnerType() != null) {
            b.append(this.getOwnerType()).append('.');
        }
        b.append(this.getRawType());
        int n = this.templateParameters.length;
        if (n != 0) {
            b.append('<');
            int i = 0;
            while (i < n) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.templateParameters[i]);
                ++i;
            }
            b.append('>');
        }
        return b.toString();
    }
}

