/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.bridj.util.Utils;

public class DefaultParameterizedType
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Type rawType;

    public DefaultParameterizedType(Type ownerType, Type rawType, Type[] actualTypeArguments) {
        this.ownerType = ownerType;
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
    }

    public DefaultParameterizedType(Type rawType, Type ... actualTypeArguments) {
        this((Type)null, rawType, actualTypeArguments);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.ownerType != null) {
            b.append(Utils.toString(this.ownerType)).append(".");
        }
        b.append(this.rawType);
        if (this.actualTypeArguments.length > 0) {
            b.append("<");
            int i = 0;
            while (i < this.actualTypeArguments.length) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(Utils.toString(this.actualTypeArguments[i]));
                ++i;
            }
            b.append(">");
        }
        return b.toString();
    }

    public static Type paramType(Type rawType, Type ... actualTypeArguments) {
        return new DefaultParameterizedType(rawType, actualTypeArguments);
    }

    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    public Type getOwnerType() {
        return this.ownerType;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        int h = this.getRawType().hashCode();
        if (this.getOwnerType() != null) {
            h ^= this.getOwnerType().hashCode();
        }
        int i = 0;
        int n = this.actualTypeArguments.length;
        while (i < n) {
            h ^= this.actualTypeArguments[i].hashCode();
            ++i;
        }
        return h;
    }

    static boolean eq(Object a, Object b) {
        if (a == null != (b == null)) {
            return false;
        }
        return a == null || a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DefaultParameterizedType)) {
            return false;
        }
        DefaultParameterizedType t = (DefaultParameterizedType)o;
        if (!DefaultParameterizedType.eq(this.getRawType(), t.getRawType())) {
            return false;
        }
        if (!DefaultParameterizedType.eq(this.getOwnerType(), t.getOwnerType())) {
            return false;
        }
        Type[] tp = t.actualTypeArguments;
        if (this.actualTypeArguments.length != tp.length) {
            return false;
        }
        int i = 0;
        int n = this.actualTypeArguments.length;
        while (i < n) {
            if (!DefaultParameterizedType.eq(this.actualTypeArguments[i], tp[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

