/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import org.bridj.NativeError;

public class LastError
extends NativeError {
    private static final long serialVersionUID = 1L;
    final int code;
    final int kind;
    String description;
    static final int eLastErrorKindWindows = 1;
    static final int eLastErrorKindCLibrary = 2;
    private static final ThreadLocal<LastError> lastError = new ThreadLocal();

    LastError(int code, int kind) {
        super((String)null);
        this.code = code;
        this.kind = kind;
    }

    public int hashCode() {
        return Integer.valueOf(this.code).hashCode() ^ Integer.valueOf(this.kind).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LastError)) {
            return false;
        }
        LastError e = (LastError)o;
        return this.code == e.code && this.kind == e.kind;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = LastError.getDescription(this.code, this.kind);
        }
        return this.description;
    }

    public String getMessage() {
        String description = this.getDescription();
        return (description == null ? "?" : description.trim()) + " (error code = " + this.code + ")";
    }

    private static native String getDescription(int var0, int var1);

    public static LastError getLastError() {
        return lastError.get();
    }

    static LastError setLastError(int code, int kind) {
        if (code == 0) {
            lastError.set(null);
            return null;
        }
        LastError err = new LastError(code, kind);
        err.fillInStackTrace();
        lastError.set(err);
        return err;
    }
}

