/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.bridj.BridJ;
import org.bridj.CLong;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.SizeT;
import org.bridj.StructCustomizer;
import org.bridj.StructDescription;
import org.bridj.StructFieldDescription;
import org.bridj.StructObject;
import org.bridj.StructUtils;
import org.bridj.TimeT;
import org.bridj.TypedPointer;
import org.bridj.ValuedEnum;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructIO {
    static Map<Type, StructIO> structIOs = new HashMap<Type, StructIO>();
    protected PointerIO<?> pointerIO;
    public final StructDescription desc;

    public static StructIO getInstance(Type structType) {
        return StructIO.getInstance(Utils.getClass(structType), structType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructIO getInstance(Class structClass, Type structType) {
        Map<Type, StructIO> map = structIOs;
        synchronized (map) {
            StructIO io = structIOs.get(structType == null ? structClass : structType);
            if (io == null && (io = new StructIO(structClass, structType)) != null) {
                StructIO.registerStructIO(structClass, structType, io);
            }
            return io;
        }
    }

    public static synchronized StructIO registerStructIO(Class structClass, Type structType, StructIO io) {
        structIOs.put(structType, io);
        return io;
    }

    public StructIO(Class<?> structClass, Type structType) {
        this.desc = new StructDescription(structClass, structType, StructCustomizer.getInstance(structClass));
    }

    public String toString() {
        return "StructIO(" + this.desc + ")";
    }

    public boolean equal(StructObject a, StructObject b) {
        return this.compare(a, b) == 0;
    }

    public int compare(StructObject a, StructObject b) {
        return StructUtils.compare(a, b, this.desc.getSolidRanges());
    }

    public final String describe(StructObject struct) {
        return this.desc.describe(struct);
    }

    public final void writeFieldsToNative(StructObject struct) {
        this.desc.build();
        if (!this.desc.hasFieldFields) {
            return;
        }
        try {
            for (StructFieldDescription fd : this.desc.fields) {
                if (fd.field == null || fd.isArray) continue;
                Object value = fd.field.get(struct);
                if (value instanceof NativeObject) {
                    if (value == null) continue;
                    BridJ.writeToNative((NativeObject)value);
                    continue;
                }
                Pointer<Object> ptr = struct.peer.offset(fd.byteOffset);
                Type tpe = fd.isNativeObject || fd.isArray ? fd.nativeTypeOrPointerTargetType : fd.field.getGenericType();
                ptr = ptr.as(tpe);
                ptr = StructUtils.fixIntegralTypeIOToMatchLength(ptr, fd.byteLength, fd.arrayLength);
                if (fd.isCLong && CLong.SIZE == 4 || fd.isSizeT && SizeT.SIZE == 4) {
                    value = (int)((Long)value).longValue();
                }
                ptr.set(value);
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Unexpected error while writing fields from struct " + Utils.toString(this.desc.structType) + " (" + Pointer.getPointer(struct) + ")", th);
        }
    }

    public final void readFieldsFromNative(StructObject struct) {
        this.desc.build();
        if (!this.desc.hasFieldFields) {
            return;
        }
        try {
            for (StructFieldDescription fd : this.desc.fields) {
                if (fd.field == null) continue;
                Pointer<Object> ptr = struct.peer.offset(fd.byteOffset);
                Type tpe = fd.isNativeObject || fd.isArray ? fd.nativeTypeOrPointerTargetType : fd.field.getGenericType();
                ptr = ptr.as(tpe);
                ptr = StructUtils.fixIntegralTypeIOToMatchLength(ptr, fd.byteLength, fd.arrayLength);
                Pointer<Object> value = fd.isArray ? (ptr = ptr.validElements(fd.arrayLength)) : ptr.get();
                fd.field.set(struct, value);
                if (!(value instanceof NativeObject) || value == null) continue;
                BridJ.readFromNative((NativeObject)((Object)value));
            }
        }
        catch (Throwable th) {
            throw new RuntimeException("Unexpected error while reading fields from struct " + Utils.toString(this.desc.structType) + " (" + Pointer.getPointer(struct) + ") : " + th, th);
        }
    }

    public final <T> Pointer<T> getPointerField(StructObject struct, int fieldIndex) {
        Pointer p;
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        if (fd.isArray) {
            p = struct.peer.offset(fd.byteOffset).as(fd.nativeTypeOrPointerTargetType);
            p = p.validElements(fd.arrayLength);
        } else {
            p = struct.peer.getPointerAtOffset(fd.byteOffset, fd.nativeTypeOrPointerTargetType);
        }
        return p;
    }

    public final <T> void setPointerField(StructObject struct, int fieldIndex, Pointer<T> value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setPointerAtOffset(fd.byteOffset, value);
    }

    public final <T extends TypedPointer> T getTypedPointerField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        PointerIO pio = PointerIO.getInstance(fd.nativeTypeOrPointerTargetType);
        return (T)((TypedPointer)pio.castTarget(struct.peer.getSizeTAtOffset(fd.byteOffset)));
    }

    public final <O extends NativeObject> O getNativeObjectField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        return struct.peer.offset(fd.byteOffset).getNativeObject(fd.nativeTypeOrPointerTargetType);
    }

    public final <O extends NativeObject> void setNativeObjectField(StructObject struct, int fieldIndex, O value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.offset(fd.byteOffset).setNativeObject(value, fd.nativeTypeOrPointerTargetType);
    }

    public final <E extends Enum<E>> IntValuedEnum<E> getEnumField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        return FlagSet.fromValue(struct.peer.getIntAtOffset(fd.byteOffset), (Class)fd.nativeTypeOrPointerTargetType);
    }

    public final void setEnumField(StructObject struct, int fieldIndex, ValuedEnum<?> value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setIntAtOffset(fd.byteOffset, (int)value.value());
    }

    private void setSignedIntegral(Pointer<?> ptr, long byteOffset, long byteLength, long bitMask, long bitOffset, long value) {
        if (bitMask != -1L) {
            long previous = ptr.getSignedIntegralAtOffset(byteOffset, byteLength);
            value <<= (int)bitOffset;
            value = previous & (bitMask ^ 0xFFFFFFFFFFFFFFFFL) | value & bitMask;
        }
        ptr.setSignedIntegralAtOffset(byteOffset, value, byteLength);
    }

    public final void setIntField(StructObject struct, int fieldIndex, int value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        if (4L != fd.byteLength || fd.bitMask != -1L) {
            this.setSignedIntegral(struct.peer, fd.byteOffset, fd.byteLength, fd.bitMask, fd.bitOffset, value);
        } else {
            struct.peer.setIntAtOffset(fd.byteOffset, value);
        }
    }

    public final int getIntField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        int value = 4L != fd.byteLength ? (int)struct.peer.getSignedIntegralAtOffset(fd.byteOffset, fd.byteLength) : struct.peer.getIntAtOffset(fd.byteOffset);
        return (int)(((long)value & fd.bitMask) >> (int)fd.bitOffset);
    }

    public final void setLongField(StructObject struct, int fieldIndex, long value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        if (8L != fd.byteLength || fd.bitMask != -1L) {
            this.setSignedIntegral(struct.peer, fd.byteOffset, fd.byteLength, fd.bitMask, fd.bitOffset, value);
        } else {
            struct.peer.setLongAtOffset(fd.byteOffset, value);
        }
    }

    public final long getLongField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        long value = 8L != fd.byteLength ? struct.peer.getSignedIntegralAtOffset(fd.byteOffset, fd.byteLength) : struct.peer.getLongAtOffset(fd.byteOffset);
        return (value & fd.bitMask) >> (int)fd.bitOffset;
    }

    public final void setShortField(StructObject struct, int fieldIndex, short value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        if (2L != fd.byteLength || fd.bitMask != -1L) {
            this.setSignedIntegral(struct.peer, fd.byteOffset, fd.byteLength, fd.bitMask, fd.bitOffset, value);
        } else {
            struct.peer.setShortAtOffset(fd.byteOffset, value);
        }
    }

    public final short getShortField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        short value = 2L != fd.byteLength ? (short)struct.peer.getSignedIntegralAtOffset(fd.byteOffset, fd.byteLength) : struct.peer.getShortAtOffset(fd.byteOffset);
        return (short)(((long)value & fd.bitMask) >> (int)fd.bitOffset);
    }

    public final void setByteField(StructObject struct, int fieldIndex, byte value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        if (1L != fd.byteLength || fd.bitMask != -1L) {
            this.setSignedIntegral(struct.peer, fd.byteOffset, fd.byteLength, fd.bitMask, fd.bitOffset, value);
        } else {
            struct.peer.setByteAtOffset(fd.byteOffset, value);
        }
    }

    public final byte getByteField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        byte value = 1L != fd.byteLength ? (byte)struct.peer.getSignedIntegralAtOffset(fd.byteOffset, fd.byteLength) : struct.peer.getByteAtOffset(fd.byteOffset);
        return (byte)(((long)value & fd.bitMask) >> (int)fd.bitOffset);
    }

    public final void setCharField(StructObject struct, int fieldIndex, char value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setCharAtOffset(fd.byteOffset, value);
    }

    public final char getCharField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        char value = struct.peer.getCharAtOffset(fd.byteOffset);
        return value;
    }

    public final void setFloatField(StructObject struct, int fieldIndex, float value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setFloatAtOffset(fd.byteOffset, value);
    }

    public final float getFloatField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        float value = struct.peer.getFloatAtOffset(fd.byteOffset);
        return value;
    }

    public final void setDoubleField(StructObject struct, int fieldIndex, double value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setDoubleAtOffset(fd.byteOffset, value);
    }

    public final double getDoubleField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        double value = struct.peer.getDoubleAtOffset(fd.byteOffset);
        return value;
    }

    public final void setBooleanField(StructObject struct, int fieldIndex, boolean value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setBooleanAtOffset(fd.byteOffset, value);
    }

    public final boolean getBooleanField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        boolean value = struct.peer.getBooleanAtOffset(fd.byteOffset);
        return value;
    }

    public final void setSizeTField(StructObject struct, int fieldIndex, long value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setSizeTAtOffset(fd.byteOffset, value);
    }

    public final long getSizeTField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        return struct.peer.getSizeTAtOffset(fd.byteOffset);
    }

    public final void setCLongField(StructObject struct, int fieldIndex, long value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setCLongAtOffset(fd.byteOffset, value);
    }

    public final long getCLongField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        return struct.peer.getCLongAtOffset(fd.byteOffset);
    }

    public final void setTimeTField(StructObject struct, int fieldIndex, TimeT value) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        struct.peer.setIntegralAtOffset(fd.byteOffset, value);
    }

    public final TimeT getTimeTField(StructObject struct, int fieldIndex) {
        StructFieldDescription fd = this.desc.fields[fieldIndex];
        return new TimeT(struct.peer.getIntegralAtOffset(fd.byteOffset, TimeT.SIZE));
    }
}

