/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.SolidRanges;
import org.bridj.StructCustomizer;
import org.bridj.StructDescription;
import org.bridj.StructFieldDeclaration;
import org.bridj.StructFieldDescription;
import org.bridj.StructIO;
import org.bridj.StructObject;
import org.bridj.ann.Alignment;
import org.bridj.ann.Struct;
import org.bridj.util.Pair;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StructUtils {
    StructUtils() {
    }

    static long alignSize(long size, long alignment) {
        long r;
        if (alignment > 1L && (r = size % alignment) != 0L) {
            size += alignment - r;
        }
        return size;
    }

    static void orderFields(List<StructFieldDeclaration> fields) {
        Collections.sort(fields, new Comparator<StructFieldDeclaration>(){

            @Override
            public int compare(StructFieldDeclaration o1, StructFieldDeclaration o2) {
                long d = o1.index - o2.index;
                if (d != 0L) {
                    return d < 0L ? -1 : (d == 0L ? 0 : 1);
                }
                if (o1.declaringClass.isAssignableFrom(o2.declaringClass)) {
                    return -1;
                }
                if (o2.declaringClass.isAssignableFrom(o1.declaringClass)) {
                    return 1;
                }
                throw new RuntimeException("Failed to order fields " + o2.desc.name + " and " + o2.desc.name);
            }
        });
    }

    static long primTypeAlignment(Class<?> primType, long length) {
        if (StructUtils.isDouble(primType) && !BridJ.alignDoubles && Platform.isLinux() && !Platform.is64Bits()) {
            return 4L;
        }
        return length;
    }

    static boolean isDouble(Class<?> primType) {
        return primType == Double.class || primType == Double.TYPE;
    }

    static int primTypeLength(Class<?> primType) {
        if (primType == Integer.class || primType == Integer.TYPE) {
            return 4;
        }
        if (primType == Long.class || primType == Long.TYPE) {
            return 8;
        }
        if (primType == Short.class || primType == Short.TYPE) {
            return 2;
        }
        if (primType == Byte.class || primType == Byte.TYPE) {
            return 1;
        }
        if (primType == Character.class || primType == Character.TYPE) {
            return 2;
        }
        if (primType == Boolean.class || primType == Boolean.TYPE) {
            return 1;
        }
        if (primType == Float.class || primType == Float.TYPE) {
            return 4;
        }
        if (StructUtils.isDouble(primType)) {
            return 8;
        }
        if (Pointer.class.isAssignableFrom(primType)) {
            return Pointer.SIZE;
        }
        throw new UnsupportedOperationException("Field type " + primType.getName() + " not supported yet");
    }

    static long alignmentOf(Type tpe) {
        Class<?> c = PointerIO.getClass(tpe);
        if (StructObject.class.isAssignableFrom(c)) {
            return StructIO.getInstance(c).desc.getStructAlignment();
        }
        return BridJ.sizeOf(tpe);
    }

    static int compare(StructObject a, StructObject b, SolidRanges solidRanges) {
        Pointer<StructObject> pA = Pointer.getPointer(a);
        Pointer<StructObject> pB = Pointer.getPointer(b);
        if (pA == null || pB == null) {
            return pA != null ? 1 : (pB != null ? -1 : 0);
        }
        long[] offsets = solidRanges.offsets;
        long[] lengths = solidRanges.lengths;
        int n = offsets.length;
        for (int i = 0; i < n; ++i) {
            long offset = offsets[i];
            long length = lengths[i];
            int cmp = pA.compareBytesAtOffset(offset, pB, offset, length);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    static String describe(StructObject struct, Type structType, StructFieldDescription[] fields) {
        StringBuilder b = new StringBuilder();
        b.append(StructUtils.describe(structType)).append(" { ");
        for (StructFieldDescription fd : fields) {
            b.append("\n\t").append(fd.name).append(" = ");
            try {
                Object value = fd.getter != null ? fd.getter.invoke((Object)struct, new Object[0]) : fd.field.get(struct);
                if (value instanceof String) {
                    b.append('\"').append(value.toString().replaceAll("\"", "\\\"")).append('\"');
                } else if (value instanceof Character) {
                    b.append('\'').append(value).append('\'');
                } else if (value instanceof NativeObject) {
                    String d = BridJ.describe((NativeObject)value);
                    b.append(d.replaceAll("\n", "\n\t"));
                } else {
                    b.append(value);
                }
            }
            catch (Throwable th) {
                if (BridJ.debug) {
                    th.printStackTrace();
                }
                b.append("?");
            }
            b.append("; ");
        }
        b.append("\n}");
        return b.toString();
    }

    static String describe(Type t) {
        if (t == null) {
            return "?";
        }
        if (t instanceof Class) {
            return ((Class)t).getSimpleName();
        }
        return t.toString().replaceAll("\\bjava\\.lang\\.", "").replaceAll("\\borg\\.bridj\\.cpp\\.com\\.", "").replaceAll("\\borg\\.bridj\\.Pointer\\b", "Pointer");
    }

    static Pointer<?> fixIntegralTypeIOToMatchLength(Pointer<?> ptr, long byteLength, long arrayLength) {
        long targetSize = ptr.getTargetSize();
        if (targetSize * arrayLength == byteLength) {
            return ptr;
        }
        Type targetType = ptr.getTargetType();
        if (!Utils.isSignedIntegral(targetType)) {
            return ptr;
        }
        switch ((int)byteLength) {
            case 1: {
                return ptr.as(Byte.TYPE);
            }
            case 2: {
                return ptr.as(Short.TYPE);
            }
            case 4: {
                return ptr.as(Integer.TYPE);
            }
            case 8: {
                return ptr.as(Long.TYPE);
            }
        }
        return ptr;
    }

    protected static void computeStructLayout(StructDescription desc, StructCustomizer customizer) {
        List<StructFieldDeclaration> fieldDecls = StructFieldDeclaration.listFields(desc.structClass);
        StructUtils.orderFields(fieldDecls);
        customizer.beforeAggregation(desc, fieldDecls);
        LinkedHashMap fieldsMap = new LinkedHashMap();
        for (StructFieldDeclaration field : fieldDecls) {
            if (field.index < 0L) {
                throw new RuntimeException("Negative field index not allowed for field " + field.desc.name);
            }
            long index = field.unionWith >= 0L ? field.unionWith : field.index;
            Pair key = new Pair(field.declaringClass, index);
            ArrayList<StructFieldDeclaration> siblings = (ArrayList<StructFieldDeclaration>)fieldsMap.get(key);
            if (siblings == null) {
                siblings = new ArrayList<StructFieldDeclaration>();
                fieldsMap.put(key, siblings);
            }
            siblings.add(field);
        }
        Alignment alignment = desc.structClass.getAnnotation(Alignment.class);
        desc.structAlignment = alignment != null ? (long)alignment.value() : 1L;
        ArrayList<StructFieldDescription> aggregatedFields = new ArrayList<StructFieldDescription>();
        for (List fieldGroup : fieldsMap.values()) {
            StructFieldDescription aggregatedField = StructFieldDescription.aggregateDeclarations(desc.structType, fieldGroup);
            if (aggregatedField == null) continue;
            aggregatedFields.add(aggregatedField);
        }
        desc.setAggregatedFields(aggregatedFields);
        customizer.beforeLayout(desc, aggregatedFields);
        StructUtils.performLayout(desc, aggregatedFields);
        customizer.afterLayout(desc, aggregatedFields);
        ArrayList<StructFieldDescription> fieldDescs = new ArrayList<StructFieldDescription>();
        SolidRanges.Builder rangesBuilder = new SolidRanges.Builder();
        for (StructFieldDescription aggregatedField : aggregatedFields) {
            for (StructFieldDeclaration field : aggregatedField.aggregatedFields) {
                StructFieldDescription fieldDesc = field.desc;
                fieldDesc.byteOffset = aggregatedField.byteOffset;
                if (fieldDesc.byteLength < 0L || fieldDesc.byteLength > aggregatedField.byteLength) {
                    fieldDesc.byteLength = aggregatedField.byteLength;
                }
                fieldDesc.bitOffset = aggregatedField.bitOffset;
                fieldDesc.bitMask = aggregatedField.bitMask;
                fieldDescs.add(fieldDesc);
                rangesBuilder.add(fieldDesc);
                desc.hasFieldFields = desc.hasFieldFields || fieldDesc.field != null;
            }
        }
        desc.solidRanges = rangesBuilder.toSolidRanges();
        desc.fields = fieldDescs.toArray(new StructFieldDescription[fieldDescs.size()]);
    }

    static void performLayout(StructDescription desc, Iterable<StructFieldDescription> aggregatedFields) {
        int pack;
        long structSize = 0L;
        long structAlignment = -1L;
        Struct s = desc.structClass.getAnnotation(Struct.class);
        int n = pack = s != null ? s.pack() : -1;
        if (desc.isVirtual()) {
            structSize += (long)Pointer.SIZE;
            if ((long)Pointer.SIZE >= structAlignment) {
                structAlignment = Pointer.SIZE;
            }
        }
        int cumulativeBitOffset = 0;
        for (StructFieldDescription aggregatedField : aggregatedFields) {
            structAlignment = Math.max(structAlignment, aggregatedField.alignment);
            if (aggregatedField.bitLength < 0L) {
                if (cumulativeBitOffset != 0) {
                    cumulativeBitOffset = 0;
                    ++structSize;
                }
                structSize = StructUtils.alignSize(structSize, pack > 0 ? (long)pack : aggregatedField.alignment);
            }
            long fieldByteOffset = structSize;
            long fieldBitOffset = cumulativeBitOffset;
            if (aggregatedField.bitLength >= 0L) {
                cumulativeBitOffset = (int)((long)cumulativeBitOffset + aggregatedField.bitLength);
                structSize += (long)(cumulativeBitOffset >>> 3);
                cumulativeBitOffset &= 7;
            } else {
                structSize += aggregatedField.byteLength;
            }
            aggregatedField.byteOffset = fieldByteOffset;
            aggregatedField.bitOffset = fieldBitOffset;
            aggregatedField.computeBitMask();
        }
        if (cumulativeBitOffset > 0) {
            structSize = StructUtils.alignSize(structSize + 1L, structAlignment);
        } else if (structSize > 0L) {
            structSize = StructUtils.alignSize(structSize, pack > 0 ? (long)pack : structAlignment);
        }
        desc.structSize = structSize;
        desc.structAlignment = structAlignment;
    }
}

