/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.IOpenCLLibrary;
import com.nativelibs4java.opencl.library.cl_buffer_region;
import com.nativelibs4java.util.NIOUtils;
import com.nativelibs4java.util.Pair;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLBuffer<T>
extends CLMem {
    final Object owner;
    final PointerIO<T> io;

    CLBuffer(CLContext context, long byteCount, long entityPeer, Object owner, PointerIO<T> io) {
        super(context, byteCount, entityPeer);
        this.owner = owner;
        this.io = io;
    }

    public Class<T> getElementClass() {
        return Utils.getClass(this.io.getTargetType());
    }

    public int getElementSize() {
        return (int)this.io.getTargetSize();
    }

    public long getElementCount() {
        return this.getByteCount() / (long)this.getElementSize();
    }

    public Pointer<T> map(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, 0L, this.getElementCount(), true, eventsToWaitFor).getFirst();
    }

    public Pointer<T> map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, offset, length, true, eventsToWaitFor).getFirst();
    }

    public Pair<Pointer<T>, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, 0L, this.getElementCount(), false, eventsToWaitFor);
    }

    public Pair<Pointer<T>, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, offset, length, false, eventsToWaitFor);
    }

    public CLEvent fillBuffer(CLQueue queue, Pointer<T> pattern, CLEvent ... eventsToWaitFor) {
        return this.fillBuffer(queue, pattern, pattern.getValidElements(), 0L, this.getElementCount(), eventsToWaitFor);
    }

    public CLEvent fillBuffer(CLQueue queue, Pointer<T> pattern, long patternLength, long offset, long length, CLEvent ... eventsToWaitFor) {
        this.context.getPlatform().requireMinVersionValue("clEnqueueFillBuffer", 1.2);
        this.checkBounds(offset, length);
        JavaCL.check(pattern != null, "Null pattern!", new Object[0]);
        long validPatternElements = pattern.getValidElements();
        JavaCL.check(validPatternElements < 0L || patternLength <= validPatternElements, "Pattern length exceeds the valid pattern elements count (%d > %d)", patternLength, validPatternElements);
        JavaCL.check(length % patternLength == 0L, "Fill length must be a multiple of pattern length", new Object[0]);
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueFillBuffer(queue.getEntity(), this.getEntity(), Pointer.getPeer(pattern), patternLength * (long)this.getElementSize(), offset * (long)this.getElementSize(), length * (long)this.getElementSize(), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    public Pointer<T> allocateCompatibleMemory(CLDevice device) {
        return Pointer.allocateArray(this.io, this.getElementCount()).order(device.getKernelsDefaultByteOrder());
    }

    public PointerIO<T> getIO() {
        return this.io;
    }

    public Pointer<T> read(CLQueue queue, CLEvent ... eventsToWaitFor) {
        Pointer<T> out = this.allocateCompatibleMemory(queue.getDevice());
        this.read(queue, out, true, eventsToWaitFor);
        return out;
    }

    public Pointer<T> read(CLQueue queue, long offset, long length, CLEvent ... eventsToWaitFor) {
        Pointer<T> out = this.allocateCompatibleMemory(queue.getDevice());
        this.read(queue, offset, length, out, true, eventsToWaitFor);
        return out;
    }

    protected void checkBounds(long offset, long length) {
        if (offset + length * (long)this.getElementSize() > this.getByteCount()) {
            throw new IndexOutOfBoundsException("Trying to map a region of memory object outside allocated range");
        }
    }

    public CLBuffer<T> createSubBuffer(CLMem.Usage usage, long offset, long length) {
        this.context.getPlatform().requireMinVersionValue("clCreateSubBuffer", 1.1);
        int s = this.getElementSize();
        cl_buffer_region region = new cl_buffer_region().origin((long)s * offset).size((long)s * length);
        ReusablePointers ptrs = ReusablePointers.get();
        Pointer<Integer> pErr = ptrs.pErr;
        long mem = JavaCL.CL.clCreateSubBuffer(this.getEntity(), usage.getIntFlags(), 4640, Pointer.getPeer(Pointer.getPointer(region)), Pointer.getPeer(pErr));
        CLException.error(pErr.getInt());
        return mem == 0L ? null : new CLBuffer<T>(this.context, length * (long)s, mem, null, this.io);
    }

    public CLEvent copyTo(CLQueue queue, CLMem destination, CLEvent ... eventsToWaitFor) {
        return this.copyTo(queue, 0L, this.getElementCount(), destination, 0L, eventsToWaitFor);
    }

    public CLEvent copyTo(CLQueue queue, long srcOffset, long length, CLMem destination, long destOffset, CLEvent ... eventsToWaitFor) {
        long byteCount = this.getByteCount();
        long destByteCount = destination.getByteCount();
        long eltSize = this.getElementSize();
        long actualSrcOffset = srcOffset * eltSize;
        long actualDestOffset = destOffset * eltSize;
        long actualLength = length * eltSize;
        if (actualSrcOffset < 0L || actualSrcOffset >= byteCount || actualSrcOffset + actualLength > byteCount || actualDestOffset < 0L || actualDestOffset >= destByteCount || actualDestOffset + actualLength > destByteCount) {
            throw new IndexOutOfBoundsException("Invalid copy parameters : srcOffset = " + srcOffset + ", destOffset = " + destOffset + ", length = " + length + " (element size = " + eltSize + ", source byte count = " + byteCount + ", destination byte count = " + destByteCount + ")");
        }
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueCopyBuffer(queue.getEntity(), this.getEntity(), destination.getEntity(), actualSrcOffset, actualDestOffset, actualLength, eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    protected Pair<Pointer<T>, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (flags == CLMem.MapFlags.WriteInvalidateRegion) {
            this.context.getPlatform().requireMinVersionValue("CL_MAP_WRITE_INVALIDATE_REGION", 1.2);
        }
        this.checkBounds(offset, length);
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer<Integer> pErr = ptrs.pErr;
        long mappedPeer = JavaCL.CL.clEnqueueMapBuffer(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, flags.value(), offset * (long)this.getElementSize(), length * (long)this.getElementSize(), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut), Pointer.getPeer(pErr));
        CLException.error(pErr.getInt());
        if (mappedPeer == 0L) {
            return null;
        }
        return new Pair<Pointer<T>, CLEvent>(Pointer.pointerToAddress(mappedPeer, this.io).validElements(length).order(queue.getDevice().getKernelsDefaultByteOrder()), CLEvent.createEventFromPointer(queue, eventOut));
    }

    public CLEvent unmap(CLQueue queue, Pointer<T> buffer, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueUnmapMemObject(queue.getEntity(), this.getEntity(), Pointer.getPeer(buffer), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    @Deprecated
    public CLEvent read(CLQueue queue, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, 0L, -1L, out, blocking, eventsToWaitFor);
    }

    public CLEvent read(CLQueue queue, Pointer<T> out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, 0L, -1L, out, blocking, eventsToWaitFor);
    }

    @Deprecated
    public CLEvent read(CLQueue queue, long offset, long length, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (out == null) {
            throw new IllegalArgumentException("Null output buffer !");
        }
        if (out.isReadOnly()) {
            throw new IllegalArgumentException("Output buffer for read operation is read-only !");
        }
        boolean indirect = !out.isDirect();
        Pointer<Object> ptr = null;
        if (indirect) {
            ptr = Pointer.allocateArray(this.io, length).order(queue.getDevice().getKernelsDefaultByteOrder());
            blocking = true;
        } else {
            ptr = Pointer.pointerToBuffer(out);
        }
        CLEvent ret = this.read(queue, offset, length, ptr, blocking, eventsToWaitFor);
        if (indirect) {
            NIOUtils.put(ptr.getBuffer(), out);
        }
        return ret;
    }

    public CLEvent read(CLQueue queue, long offset, long length, Pointer<T> out, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (out == null) {
            throw new IllegalArgumentException("Null output pointer !");
        }
        if (length < 0L) {
            long s;
            if (this.isGL) {
                length = out.getValidElements();
            }
            if (length < 0L && (length = this.getElementCount()) > (s = out.getValidElements()) && s >= 0L) {
                length = s;
            }
        }
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueReadBuffer(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, offset * (long)this.getElementSize(), length * (long)this.getElementSize(), Pointer.getPeer(out), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    @Deprecated
    public CLEvent write(CLQueue queue, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, 0L, -1L, in, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, Pointer<T> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, 0L, -1L, in, blocking, eventsToWaitFor);
    }

    @Deprecated
    public CLEvent write(CLQueue queue, long offset, long length, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (in == null) {
            throw new IllegalArgumentException("Null input buffer !");
        }
        boolean indirect = !in.isDirect();
        Pointer<Object> ptr = null;
        if (indirect) {
            ptr = Pointer.allocateArray(this.io, length).order(queue.getDevice().getKernelsDefaultByteOrder());
            ptr.setValues(in);
            blocking = true;
        } else {
            ptr = Pointer.pointerToBuffer(in);
        }
        return this.write(queue, offset, length, ptr, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, long offset, long length, Pointer<T> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (length == 0L) {
            return null;
        }
        if (in == null) {
            throw new IllegalArgumentException("Null input pointer !");
        }
        if (length < 0L) {
            long s;
            if (this.isGL) {
                length = in.getValidElements();
            }
            if (length < 0L && (length = this.getElementCount()) > (s = in.getValidElements()) && s >= 0L) {
                length = s;
            }
        }
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueWriteBuffer(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, offset * (long)this.getElementSize(), length * (long)this.getElementSize(), Pointer.getPeer(in), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    public CLEvent writeBytes(CLQueue queue, long offset, long length, ByteBuffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.writeBytes(queue, offset, length, Pointer.pointerToBuffer(in), blocking, eventsToWaitFor);
    }

    public CLEvent writeBytes(CLQueue queue, long offset, long length, Pointer<?> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (in == null) {
            throw new IllegalArgumentException("Null input pointer !");
        }
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueWriteBuffer(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, offset, length, Pointer.getPeer(in), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    private <T extends CLMem> T copyGLMark(T mem) {
        mem.isGL = this.isGL;
        return mem;
    }

    public CLBuffer<T> emptyClone(CLMem.Usage usage) {
        return this.getContext().createBuffer(usage, this.io, this.getElementCount());
    }

    public CLBuffer<Integer> asCLIntBuffer() {
        return this.as(Integer.class);
    }

    public CLBuffer<Long> asCLLongBuffer() {
        return this.as(Long.class);
    }

    public CLBuffer<Short> asCLShortBuffer() {
        return this.as(Short.class);
    }

    public CLBuffer<Byte> asCLByteBuffer() {
        return this.as(Byte.class);
    }

    public CLBuffer<Character> asCLCharBuffer() {
        return this.as(Character.class);
    }

    public CLBuffer<Float> asCLFloatBuffer() {
        return this.as(Float.class);
    }

    public CLBuffer<Double> asCLDoubleBuffer() {
        return this.as(Double.class);
    }

    public <T> CLBuffer<T> as(Class<T> newTargetType) {
        long mem = this.getEntity();
        assert (mem != 0L);
        CLException.error(JavaCL.CL.clRetainMemObject(mem));
        PointerIO newIO = PointerIO.getInstance(newTargetType);
        return this.copyGLMark(new CLBuffer(this.context, this.getByteCount(), mem, this.owner, newIO));
    }

    public CLEvent copyTo(CLQueue queue, CLBuffer destination, CLEvent ... eventsToWaitFor) {
        return this.copyBytesTo(queue, destination, 0L, 0L, this.getByteCount(), eventsToWaitFor);
    }

    public CLEvent copyBytesTo(CLQueue queue, CLBuffer destination, long sourceByteOffset, long destinationByteOffset, long byteCount, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueCopyBuffer(queue.getEntity(), this.getEntity(), destination.getEntity(), sourceByteOffset, destinationByteOffset, byteCount, eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    public CLEvent copyElementsTo(CLQueue queue, CLBuffer destination, long sourceElementOffset, long destinationElementOffset, long elementCount, CLEvent ... eventsToWaitFor) {
        long elementSize = this.getElementSize();
        return this.copyBytesTo(queue, destination, sourceElementOffset * elementSize, destinationElementOffset * elementSize, elementCount * elementSize, eventsToWaitFor);
    }
}

