/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLUserEvent;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.IOpenCLLibrary;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.ValuedEnum;
import java.util.Arrays;
import org.bridj.JNI;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.ann.Ptr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLEvent
extends CLAbstractEntity {
    public static final CLEvent FIRE_AND_FORGET = new CLEvent(null, -1L);
    protected static CLInfoGetter infos = new CLInfoGetter(){

        @Override
        protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return JavaCL.CL.clGetEventInfo(entity, infoTypeEnum, size, Pointer.getPeer(out), Pointer.getPeer(sizeOut));
        }
    };
    protected static CLInfoGetter profilingInfos = new CLInfoGetter(){

        @Override
        protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return JavaCL.CL.clGetEventProfilingInfo(entity, infoTypeEnum, size, Pointer.getPeer(out), Pointer.getPeer(sizeOut));
        }
    };
    private final CLQueue queue;
    private static final IOpenCLLibrary.clSetEventCallback_arg1_callback eventCallback = new IOpenCLLibrary.clSetEventCallback_arg1_callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(@Ptr long evt, int executionStatus, @Ptr long callbackPeer) {
            EventCallback callback = (EventCallback)JNI.refToObject(callbackPeer);
            try {
                callback.callback(executionStatus);
            }
            finally {
                JNI.deleteGlobalRef(callbackPeer);
            }
        }
    };
    private static final long eventCallbackPeer = Pointer.getPeer(Pointer.getPointer(eventCallback));

    CLEvent(CLQueue queue, long evt) {
        super(evt, false);
        this.queue = queue;
    }

    public CLQueue getQueue() {
        return this.queue;
    }

    public void setCompletionCallback(EventCallback callback) {
        this.setCallback(0, callback);
    }

    public void setCallback(int commandExecStatus, EventCallback callback) {
        this.queue.getContext().getPlatform().requireMinVersionValue("clSetEventCallback", 1.1);
        CLException.error(JavaCL.CL.clSetEventCallback(this.getEntity(), commandExecStatus, eventCallbackPeer, JNI.newGlobalRef(callback)));
    }

    static CLEvent createEvent(CLQueue queue, long evt) {
        return CLEvent.createEvent(queue, evt, false);
    }

    static CLEvent createEvent(CLQueue queue, long evt, boolean isUserEvent) {
        if (evt == 0L) {
            return null;
        }
        return isUserEvent ? new CLUserEvent(queue, evt) : new CLEvent(queue, evt);
    }

    static CLEvent createEventFromPointer(CLQueue queue, Pointer<IOpenCLLibrary.cl_event> evt1) {
        if (evt1 == null) {
            return null;
        }
        long peer = evt1.getSizeT();
        if (peer == 0L) {
            return null;
        }
        return new CLEvent(queue, peer);
    }

    public void waitFor() {
        CLEvent.waitFor(this);
    }

    public static void waitFor(CLEvent ... eventsToWaitFor) {
        if (eventsToWaitFor.length == 0) {
            return;
        }
        try {
            ReusablePointers ptrs = ReusablePointers.get();
            int[] eventsInCount = ptrs.int1Array;
            Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
            if (eventsIn == null) {
                return;
            }
            CLException.error(JavaCL.CL.clWaitForEvents(eventsInCount[0], Pointer.getPeer(eventsIn)));
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while waiting for events " + Arrays.asList(eventsToWaitFor), ex);
        }
    }

    public void invokeUponCompletion(Runnable action) {
        CLEvent.invokeUponCompletion(action, this);
    }

    public static void invokeUponCompletion(final Runnable action, final CLEvent ... eventsToWaitFor) {
        if (action == null) {
            throw new IllegalArgumentException("Null action !");
        }
        new Thread(){

            public void run() {
                CLEvent.waitFor(eventsToWaitFor);
                action.run();
            }
        }.start();
    }

    static boolean containsFireAndForget(CLEvent[] eventsToWaitFor) {
        int i = eventsToWaitFor.length;
        while (i-- != 0) {
            if (eventsToWaitFor[i] != FIRE_AND_FORGET) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseEvent(this.getEntity()));
    }

    public CommandExecutionStatus getCommandExecutionStatus() {
        int v = infos.getInt(this.getEntity(), 4563);
        CommandExecutionStatus status = CommandExecutionStatus.getEnum(v);
        if (status == null) {
            CLException.error(v);
        }
        return status;
    }

    @InfoName(value="CL_EVENT_COMMAND_EXECUTION_STATUS")
    public int getCommandExecutionStatusValue() {
        return infos.getInt(this.getEntity(), 4563);
    }

    @InfoName(value="CL_EVENT_COMMAND_TYPE")
    public CommandType getCommandType() {
        return CommandType.getEnum(infos.getInt(this.getEntity(), 4561));
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_QUEUED")
    public long getProfilingCommandQueued() {
        return profilingInfos.getIntOrLong(this.getEntity(), 4736);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_SUBMIT")
    public long getProfilingCommandSubmit() {
        return profilingInfos.getIntOrLong(this.getEntity(), 4737);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_START")
    public long getProfilingCommandStart() {
        return profilingInfos.getIntOrLong(this.getEntity(), 4738);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_END")
    public long getProfilingCommandEnd() {
        return profilingInfos.getIntOrLong(this.getEntity(), 4739);
    }

    public String toString() {
        return "Event {commandType: " + this.getCommandType() + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandType implements ValuedEnum
    {
        NDRangeKernel(4592L),
        Task(4593L),
        NativeKernel(4594L),
        ReadBuffer(4595L),
        WriteBuffer(4596L),
        CopyBuffer(4597L),
        ReadImage(4598L),
        WriteImage(4599L),
        CopyImage(4600L),
        CopyBufferToImage(4602L),
        CopyImageToBuffer(4601L),
        MapBuffer(4603L),
        CommandMapImage(4604L),
        UnmapMemObject(4605L),
        Marker(4606L),
        AcquireGLObjects(4607L),
        ReleaseGLObjects(4608L);

        long value;

        private CommandType(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static CommandType getEnum(long v) {
            return EnumValues.getEnum(v, CommandType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandExecutionStatus implements ValuedEnum
    {
        Queued(3L),
        Submitted(2L),
        Running(1L),
        Complete(0L);

        long value;

        private CommandExecutionStatus(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static CommandExecutionStatus getEnum(long v) {
            return EnumValues.getEnum(v, CommandExecutionStatus.class);
        }
    }

    public static interface EventCallback {
        public void callback(int var1);
    }
}

