/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.ochafik.util.string.StringUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bridj.Pointer;

public class CLException
extends RuntimeException {
    protected int code;
    static final String logSuffix = System.getenv("CL_LOG_ERRORS") == null ? " (make sure to log all errors with environment variable CL_LOG_ERRORS=stdout)" : "";
    static Map<Integer, Class<? extends CLTypedException>> typedErrorClassesByCode;

    CLException(String message, int code) {
        super(message);
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static String errorString(int err) {
        if (err == 0) {
            return null;
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (Field f : OpenCLLibrary.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(Integer.TYPE)) continue;
            try {
                int i = (Integer)f.get(null);
                if (i != err) continue;
                String name = f.getName();
                String lname = name.toLowerCase();
                if (lname.contains("invalid") || lname.contains("bad") || lname.contains("illegal") || lname.contains("wrong")) {
                    candidates.clear();
                    candidates.add(name);
                    break;
                }
                candidates.add(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return StringUtils.implode(candidates, (Object)" or ");
    }

    static boolean failedForLackOfMemory(int err, int previousAttempts) {
        switch (err) {
            case 0: {
                return false;
            }
            case -6: 
            case -5: 
            case -4: {
                if (previousAttempts > 1) break;
                System.gc();
                if (previousAttempts == 1) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        CLException.error(err);
        assert (false);
        return false;
    }

    public static void error(int err) {
        CLException toThrow;
        block9: {
            if (err == 0) {
                return;
            }
            if (typedErrorClassesByCode == null) {
                typedErrorClassesByCode = new HashMap<Integer, Class<? extends CLTypedException>>();
                for (Class<?> c : CLException.class.getDeclaredClasses()) {
                    if (c == CLTypedException.class || !CLTypedException.class.isAssignableFrom(c)) continue;
                    typedErrorClassesByCode.put(c.getAnnotation(ErrorCode.class).value(), c);
                }
            }
            toThrow = null;
            Class<? extends CLTypedException> c = typedErrorClassesByCode.get(err);
            if (c != null) {
                try {
                    toThrow = c.newInstance();
                }
                catch (InstantiationException ex) {
                    assert (JavaCL.log(Level.SEVERE, null, ex));
                }
                catch (IllegalAccessException ex) {
                    if ($assertionsDisabled || JavaCL.log(Level.SEVERE, null, ex)) break block9;
                    throw new AssertionError();
                }
            }
        }
        if (toThrow == null) {
            toThrow = new CLException("OpenCL Error : " + CLException.errorString(err) + logSuffix, err);
        }
        throw toThrow;
    }

    @ErrorCode(value=-11)
    public static class BuildProgramFailure
    extends CLTypedException {
    }

    @ErrorCode(value=-43)
    public static class InvalidBuildOptions
    extends CLTypedException {
    }

    @ErrorCode(value=-31)
    public static class InvalidDeviceType
    extends CLTypedException {
    }

    @ErrorCode(value=-41)
    public static class InvalidSampler
    extends CLTypedException {
    }

    @ErrorCode(value=-30)
    public static class InvalidValue
    extends CLTypedException {
    }

    @ErrorCode(value=-35)
    public static class InvalidQueueProperties
    extends CLTypedException {
    }

    @ErrorCode(value=-45)
    public static class InvalidProgramExecutable
    extends CLTypedException {
    }

    @ErrorCode(value=-44)
    public static class InvalidProgram
    extends CLTypedException {
    }

    @ErrorCode(value=-62)
    public static class InvalidMipLevel
    extends CLTypedException {
    }

    @ErrorCode(value=-38)
    public static class InvalidMemObject
    extends CLTypedException {
    }

    @ErrorCode(value=-46)
    public static class InvalidKernelName
    extends CLTypedException {
    }

    @ErrorCode(value=-47)
    public static class InvalidKernelDefinition
    extends CLTypedException {
    }

    @ErrorCode(value=-52)
    public static class InvalidKernelArgs
    extends CLTypedException {
    }

    @ErrorCode(value=-60)
    public static class InvalidGLObject
    extends CLTypedException {
    }

    @ErrorCode(value=-1000)
    public static class InvalidGLShareGroupReference
    extends CLTypedException {
    }

    @ErrorCode(value=-1000)
    public static class InvalidGLContextApple
    extends CLTypedException {
    }

    @ErrorCode(value=-48)
    public static class InvalidKernel
    extends CLTypedException {
    }

    @ErrorCode(value=-34)
    public static class InvalidContext
    extends CLTypedException {
    }

    @ErrorCode(value=-8)
    public static class MemCopyOverlap
    extends CLTypedException {
    }

    @ErrorCode(value=-36)
    public static class InvalidCommandQueue
    extends CLTypedException {
    }

    @ErrorCode(value=-64)
    public static class InvalidProperty
    extends CLTypedException {
    }

    @ErrorCode(value=-32)
    public static class InvalidPlatform
    extends CLTypedException {
    }

    @ErrorCode(value=-67)
    public static class InvalidLinkerOptions
    extends CLTypedException {
    }

    @ErrorCode(value=-65)
    public static class InvalidImageDescriptor
    extends CLTypedException {
    }

    @ErrorCode(value=-37)
    public static class InvalidHostPtr
    extends CLTypedException {
    }

    @ErrorCode(value=-68)
    public static class InvalidDevicePartitionCount
    extends CLTypedException {
    }

    @ErrorCode(value=-33)
    public static class InvalidDevice
    extends CLTypedException {
    }

    @ErrorCode(value=-66)
    public static class InvalidCompilerOptions
    extends CLTypedException {
    }

    @ErrorCode(value=-6)
    public static class OutOfHostMemory
    extends CLTypedException {
    }

    @ErrorCode(value=-56)
    public static class InvalidGlobalOffset
    extends CLTypedException {
    }

    @ErrorCode(value=-61)
    public static class InvalidBufferSize
    extends CLTypedException {
    }

    @ErrorCode(value=-59)
    public static class InvalidOperation
    extends CLTypedException {
    }

    @ErrorCode(value=-55)
    public static class InvalidWorkItemSize
    extends CLTypedException {
    }

    @ErrorCode(value=-54)
    public static class InvalidWorkGroupSize
    extends CLTypedException {
    }

    @ErrorCode(value=-53)
    public static class InvalidWorkDimension
    extends CLTypedException {
    }

    @ErrorCode(value=-40)
    public static class InvalidImageSize
    extends CLTypedException {
    }

    @ErrorCode(value=-39)
    public static class InvalidImageFormatDescriptor
    extends CLTypedException {
    }

    @ErrorCode(value=-58)
    public static class InvalidEvent
    extends CLTypedException {
    }

    @ErrorCode(value=-42)
    public static class InvalidBinary
    extends CLTypedException {
    }

    @ErrorCode(value=-50)
    public static class InvalidArgValue
    extends CLTypedException {
    }

    @ErrorCode(value=-51)
    public static class InvalidArgSize
    extends CLTypedException {
    }

    @ErrorCode(value=-49)
    public static class InvalidArgIndex
    extends CLTypedException {
    }

    @ErrorCode(value=-57)
    public static class InvalidEventWaitList
    extends CLTypedException {
    }

    @ErrorCode(value=-4)
    public static class MemObjectAllocationFailure
    extends CLTypedException {
    }

    @ErrorCode(value=-12)
    public static class MapFailure
    extends CLTypedException {
    }

    @ErrorCode(value=-63)
    public static class InvalidGlobalWorkSize
    extends CLTypedException {
    }

    @ErrorCode(value=-3)
    public static class CompilerNotAvailable
    extends CLTypedException {
    }

    @ErrorCode(value=-5)
    public static class OutOfResources
    extends CLTypedException {
    }

    @ErrorCode(value=-2)
    public static class DeviceNotAvailable
    extends CLTypedException {
    }

    @ErrorCode(value=-7)
    public static class ProfilingInfoNotAvailable
    extends CLTypedException {
    }

    @ErrorCode(value=-9)
    public static class ImageFormatMismatch
    extends CLTypedException {
    }

    @ErrorCode(value=-19)
    public static class KernelArgInfoNotAvailable
    extends CLTypedException {
    }

    @ErrorCode(value=-17)
    public static class LinkProgramFailure
    extends CLTypedException {
    }

    @ErrorCode(value=-16)
    public static class LinkerNotAvailable
    extends CLTypedException {
    }

    @ErrorCode(value=-15)
    public static class CompileProgramFailure
    extends CLTypedException {
    }

    @ErrorCode(value=-13)
    public static class MisalignedSubBufferOffset
    extends CLTypedException {
    }

    @ErrorCode(value=-14)
    public static class ExecStatusErrorForEventsInWaitList
    extends CLTypedException {
    }

    @ErrorCode(value=-18)
    public static class DevicePartitionFailed
    extends CLTypedException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CLTypedException
    extends CLException {
        protected String message;

        public CLTypedException() {
            super("", 0);
            ErrorCode code = this.getClass().getAnnotation(ErrorCode.class);
            this.code = code.value();
            this.message = this.getClass().getSimpleName();
        }

        @Override
        public String getMessage() {
            return this.message + logSuffix;
        }

        void setKernelArg(CLKernel kernel, int argIndex, long size, Pointer<?> ptr) {
            this.message = this.message + " (kernel name = " + kernel.getFunctionName();
            this.message = this.message + ", num args = " + kernel.getNumArgs();
            this.message = this.message + ", arg index = " + argIndex;
            this.message = this.message + ", arg size = " + size;
            CLProgram program = kernel.getProgram();
            if (program != null) {
                this.message = this.message + ", source = <<<\n\t" + program.getSource().replaceAll("\n", "\n\t");
            }
            this.message = this.message + "\n>>> )";
        }
    }

    public static class CLVersionException
    extends CLException {
        public CLVersionException(String message) {
            super(message, 0);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface ErrorCode {
        public int value();
    }
}

