/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointer;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.IOpenCLLibrary;
import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.Pair;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLImage
extends CLMem {
    CLImageFormat format;

    CLImage(CLContext context, long entityPeer, CLImageFormat format) {
        super(context, -1L, entityPeer);
        this.format = format;
    }

    protected abstract long[] getDimensions();

    @InfoName(value="CL_IMAGE_FORMAT")
    public CLImageFormat getFormat() {
        if (this.format == null) {
            this.format = new CLImageFormat(new cl_image_format(infos.getMemory(this.getEntity(), 4368)));
        }
        return this.format;
    }

    @InfoName(value="CL_IMAGE_ELEMENT_SIZE")
    public long getElementSize() {
        return infos.getIntOrLong(this.getEntity(), 4369);
    }

    protected CLEvent read(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, origin, region, rowPitch, slicePitch, Pointer.pointerToBuffer(out), blocking, eventsToWaitFor);
    }

    protected CLEvent read(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Pointer<?> out, boolean blocking, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueReadImage(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, Pointer.getPeer(origin), Pointer.getPeer(region), rowPitch, slicePitch, Pointer.getPeer(out), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    protected CLEvent write(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, origin, region, rowPitch, slicePitch, Pointer.pointerToBuffer(in), blocking, eventsToWaitFor);
    }

    protected CLEvent write(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Pointer<?> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueWriteImage(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, Pointer.getPeer(origin), Pointer.getPeer(region), rowPitch, slicePitch, Pointer.getPeer(in), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        CLEvent evt = CLEvent.createEventFromPointer(queue, eventOut);
        if (!blocking) {
            final Pointer<?> toHold = in;
            evt.invokeUponCompletion(new Runnable(){

                public void run() {
                    toHold.order();
                }
            });
        }
        return evt;
    }

    public CLEvent fillImage(CLQueue queue, Object color, CLEvent ... eventsToWaitFor) {
        long[] region = this.getDimensions();
        long[] origin = new long[region.length];
        return this.fillImage(queue, color, origin, region, eventsToWaitFor);
    }

    public CLEvent fillImage(CLQueue queue, Object color, long[] origin, long[] region, CLEvent ... eventsToWaitFor) {
        Pointer<Number> pColor;
        this.context.getPlatform().requireMinVersionValue("clEnqueueFillImage", 1.2);
        if (color instanceof int[]) {
            pColor = Pointer.pointerToInts((int[])color);
        } else if (color instanceof float[]) {
            pColor = Pointer.pointerToFloats((float[])color);
        } else {
            throw new IllegalArgumentException("Color should be an int[] or a float[] with 4 elements.");
        }
        JavaCL.check(pColor.getValidElements() == 4L, "Color should have 4 elements.", new Object[0]);
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueFillImage(queue.getEntity(), this.getEntity(), Pointer.getPeer(pColor), Pointer.getPeer(this.writeOrigin(origin, ptrs.sizeT3_1)), Pointer.getPeer(this.writeRegion(region, ptrs.sizeT3_2)), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    protected Pair<ByteBuffer, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, Pointer<SizeT> offset3, Pointer<SizeT> length3, Long imageRowPitch, Long imageSlicePitch, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (flags == CLMem.MapFlags.WriteInvalidateRegion) {
            this.context.getPlatform().requireMinVersionValue("CL_MAP_WRITE_INVALIDATE_REGION", 1.2);
        }
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer<Integer> pErr = ptrs.pErr;
        long mappedPeer = JavaCL.CL.clEnqueueMapImage(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, flags.value(), Pointer.getPeer(offset3), Pointer.getPeer(length3), imageRowPitch == null ? 0L : Pointer.getPeer(ptrs.sizeT3_1.pointerToSizeTs(imageRowPitch)), imageSlicePitch == null ? 0L : Pointer.getPeer(ptrs.sizeT3_2.pointerToSizeTs(imageSlicePitch)), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut), Pointer.getPeer(pErr));
        CLException.error(pErr.getInt());
        return new Pair<ByteBuffer, CLEvent>(Pointer.pointerToAddress(mappedPeer).getByteBuffer(this.getByteCount()), CLEvent.createEventFromPointer(queue, eventOut));
    }

    public CLEvent unmap(CLQueue queue, ByteBuffer buffer, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer<?> pBuffer = Pointer.pointerToBuffer(buffer);
        CLException.error(JavaCL.CL.clEnqueueUnmapMemObject(queue.getEntity(), this.getEntity(), Pointer.getPeer(pBuffer), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    protected abstract Pointer<SizeT> writeOrigin(long[] var1, ReusablePointer var2);

    protected abstract Pointer<SizeT> writeRegion(long[] var1, ReusablePointer var2);

    public CLEvent copyTo(CLQueue queue, CLImage destination, CLEvent ... eventsToWaitFor) {
        long[] region = this.getDimensions();
        long[] origin = new long[region.length];
        return this.copyTo(queue, destination, origin, origin, region, eventsToWaitFor);
    }

    public CLEvent copyTo(CLQueue queue, CLImage destination, long[] sourceOrigin, long[] destinationOrigin, long[] region, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueCopyImage(queue.getEntity(), this.getEntity(), destination.getEntity(), Pointer.getPeer(this.writeOrigin(sourceOrigin, ptrs.sizeT3_1)), Pointer.getPeer(this.writeOrigin(destinationOrigin, ptrs.sizeT3_2)), Pointer.getPeer(this.writeRegion(region, ptrs.sizeT3_3)), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }
}

