/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.LocalSize;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.IOpenCLLibrary;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLKernel
extends CLAbstractEntity {
    protected final CLProgram program;
    protected String name;
    protected static CLInfoGetter infos = new CLInfoGetter(){

        @Override
        protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return JavaCL.CL.clGetKernelInfo(entity, infoTypeEnum, size, Pointer.getPeer(out), Pointer.getPeer(sizeOut));
        }
    };
    private volatile CLInfoGetter kernelInfos;
    private static final int MAX_TMP_ITEMS = 16;
    private static final int MAX_TMP_ITEM_SIZE = 8;
    private final Pointer<?> localPointer = Pointer.allocateBytes(128L).withoutValidityInformation();
    private final int contextAddressBits;
    public static final Object NULL_POINTER_KERNEL_ARGUMENT = new Object(){};
    private static final Pointer<SizeT> oneNL = Pointer.pointerToSizeT(1L);

    protected synchronized CLInfoGetter getKernelInfos() {
        if (this.kernelInfos == null) {
            this.kernelInfos = new CLInfoGetter(){

                @Override
                protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
                    return JavaCL.CL.clGetKernelWorkGroupInfo(CLKernel.this.getEntity(), entity, infoTypeEnum, size, Pointer.getPeer(out), Pointer.getPeer(sizeOut));
                }
            };
        }
        return this.kernelInfos;
    }

    CLKernel(CLProgram program, String name, long entity) {
        super(entity);
        this.program = program;
        this.name = name;
        this.contextAddressBits = this.getProgram().getContext().getAddressBits();
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public String toString() {
        return this.getFunctionName() + " {args: " + this.getNumArgs() + "}";
    }

    public Map<CLDevice, Long> getPreferredWorkGroupSizeMultiple() {
        this.program.getContext().getPlatform().requireMinVersionValue("CL_KERNEL_PREFERRED_WORK_GROUP_SIZE_MULTIPLE", 1.1);
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getIntOrLong(device.getEntity(), 4531));
        }
        return ret;
    }

    public Map<CLDevice, Long> getWorkGroupSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getIntOrLong(device.getEntity(), 4528));
        }
        return ret;
    }

    public Map<CLDevice, long[]> getCompileWorkGroupSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, long[]> ret = new HashMap<CLDevice, long[]>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getNativeSizes(device.getEntity(), 4529, 3));
        }
        return ret;
    }

    public Map<CLDevice, Long> getLocalMemSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getIntOrLong(device.getEntity(), 4530));
        }
        return ret;
    }

    public void setArgs(Object ... args) {
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            this.setObjectArg(i, args[i]);
        }
    }

    public void setObjectArg(int iArg, Object arg) {
        boolean supported = true;
        if (arg instanceof CLAbstractEntity) {
            this.setArg(iArg, (CLAbstractEntity)arg);
        } else if (arg instanceof Number) {
            if (arg instanceof Integer) {
                this.setArg(iArg, (Integer)arg);
            } else if (arg instanceof Long) {
                this.setArg(iArg, (Long)arg);
            } else if (arg instanceof Short) {
                this.setArg(iArg, (Short)arg);
            } else if (arg instanceof Byte) {
                this.setArg(iArg, (Byte)arg);
            } else if (arg instanceof Float) {
                this.setArg(iArg, ((Float)arg).floatValue());
            } else if (arg instanceof Double) {
                this.setArg(iArg, (Double)arg);
            } else {
                supported = false;
            }
        } else if (arg instanceof LocalSize) {
            this.setArg(iArg, (LocalSize)arg);
        } else if (arg instanceof Boolean) {
            this.setArg(iArg, (Boolean)arg);
        } else if (arg instanceof SizeT) {
            this.setArg(iArg, (SizeT)arg);
        } else if (arg == NULL_POINTER_KERNEL_ARGUMENT) {
            this.setArg(iArg, SizeT.ZERO);
        } else {
            Class<?> cls = arg.getClass();
            if (cls.isArray()) {
                if (arg instanceof int[]) {
                    this.setArg(iArg, (int[])arg);
                } else if (arg instanceof long[]) {
                    this.setArg(iArg, (long[])arg);
                } else if (arg instanceof short[]) {
                    this.setArg(iArg, (short[])arg);
                } else if (arg instanceof double[]) {
                    this.setArg(iArg, (double[])arg);
                } else if (arg instanceof float[]) {
                    this.setArg(iArg, (float[])arg);
                } else if (arg instanceof byte[]) {
                    this.setArg(iArg, (byte[])arg);
                } else if (arg instanceof boolean[]) {
                    this.setArg(iArg, (boolean[])arg);
                } else {
                    supported = false;
                }
            } else if (arg instanceof Pointer) {
                this.setArg(iArg, (Pointer)arg);
            } else if (arg instanceof Buffer) {
                this.setArg(iArg, Pointer.pointerToBuffer((Buffer)arg));
            } else {
                supported = false;
            }
        }
        if (arg == null) {
            throw new IllegalArgumentException("Null arguments are not accepted. Please use CLKernel.NULL_POINTER_KERNEL_ARGUMENT instead.");
        }
        if (!supported) {
            throw new IllegalArgumentException("Cannot handle kernel arguments of type " + arg.getClass().getName() + ". Use CLKernel.get() and OpenCL4Java directly.");
        }
    }

    public void setArg(int i, LocalSize arg) {
        this.setLocalArg(i, arg.size);
    }

    public void setLocalArg(int argIndex, long localArgByteLength) {
        this.setKernelArg(argIndex, localArgByteLength, null);
    }

    private void setKernelArg(int i, long size, Pointer<?> ptr) {
        if (size <= 0L) {
            throw new IllegalArgumentException("Kernel args must have a known byte size, given " + size + " instead.");
        }
        try {
            CLException.error(JavaCL.CL.clSetKernelArg(this.getEntity(), i, size, Pointer.getPeer(ptr)));
        }
        catch (CLException.CLTypedException ex) {
            ex.setKernelArg(this, i, size, ptr);
            throw ex;
        }
    }

    public void setArg(int i, Pointer<?> ptr) {
        this.setKernelArg(i, ptr.getValidBytes(), ptr);
    }

    public void setArg(int i, int[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 4, length <= 16 ? this.localPointer.setInts(arg) : Pointer.pointerToInts(arg));
    }

    public void setArg(int i, long[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 8, length <= 16 ? this.localPointer.setLongs(arg) : Pointer.pointerToLongs(arg));
    }

    public void setArg(int i, short[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 2, length <= 16 ? this.localPointer.setShorts(arg) : Pointer.pointerToShorts(arg));
    }

    public void setArg(int i, byte[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 1, length <= 16 ? this.localPointer.setBytes(arg) : Pointer.pointerToBytes(arg));
    }

    public void setArg(int i, char[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 2, length <= 16 ? this.localPointer.setChars(arg) : Pointer.pointerToChars(arg));
    }

    public void setArg(int i, float[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 4, length <= 16 ? this.localPointer.setFloats(arg) : Pointer.pointerToFloats(arg));
    }

    public void setArg(int i, double[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 8, length <= 16 ? this.localPointer.setDoubles(arg) : Pointer.pointerToDoubles(arg));
    }

    public void setArg(int i, boolean[] arg) {
        int length = CLKernel.normalizeVectorTypeArity(arg.length);
        this.setKernelArg(i, length * 1, length <= 16 ? this.localPointer.setBooleans(arg) : Pointer.pointerToBooleans(arg));
    }

    private static int normalizeVectorTypeArity(int length) {
        switch (length) {
            case 3: {
                return 4;
            }
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return length;
            }
        }
        throw new IllegalArgumentException("Invalid vector type length: " + length + " (valid vector type sizes are 2, 3, 4, 8, 16)");
    }

    public void setArg(int i, SizeT arg) {
        switch (this.contextAddressBits) {
            case 32: {
                this.setKernelArg(i, 4L, this.localPointer.setInt(arg.intValue()));
                break;
            }
            case 64: {
                this.setKernelArg(i, 8L, this.localPointer.setLong(arg.longValue()));
                break;
            }
            default: {
                this.setKernelArg(i, SizeT.SIZE, this.localPointer.setSizeT(arg.longValue()));
            }
        }
    }

    public void setArg(int i, int arg) {
        this.setKernelArg(i, 4L, this.localPointer.setInt(arg));
    }

    public void setArg(int i, long arg) {
        this.setKernelArg(i, 8L, this.localPointer.setLong(arg));
    }

    public void setArg(int i, short arg) {
        this.setKernelArg(i, 2L, this.localPointer.setShort(arg));
    }

    public void setArg(int i, byte arg) {
        this.setKernelArg(i, 1L, this.localPointer.setByte(arg));
    }

    public void setArg(int i, boolean arg) {
        this.setKernelArg(i, 1L, this.localPointer.setByte(arg ? (byte)1 : 0));
    }

    public void setArg(int i, float arg) {
        this.setKernelArg(i, 4L, this.localPointer.setFloat(arg));
    }

    public void setArg(int i, double arg) {
        this.setKernelArg(i, 8L, this.localPointer.setDouble(arg));
    }

    public void setArg(int i, CLAbstractEntity arg) {
        this.setKernelArg(i, Pointer.SIZE, this.localPointer.setSizeT(arg.getEntity()));
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseKernel(this.getEntity()));
    }

    public CLEvent enqueueTask(CLQueue queue, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueTask(queue.getEntity(), this.getEntity(), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalWorkSizes, int[] localWorkSizes, CLEvent ... eventsToWaitFor) {
        return this.enqueueNDRange(queue, (int[])null, globalWorkSizes, localWorkSizes, eventsToWaitFor);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalWorkSizes, CLEvent ... eventsToWaitFor) {
        return this.enqueueNDRange(queue, (int[])null, globalWorkSizes, (int[])null, eventsToWaitFor);
    }

    public CLEvent enqueueNDRange(CLQueue queue, long[] globalOffsets, long[] globalWorkSizes, long[] localWorkSizes, CLEvent ... eventsToWaitFor) {
        int nDims = globalWorkSizes.length;
        if (localWorkSizes != null && localWorkSizes.length != nDims) {
            throw new IllegalArgumentException("Global and local sizes must have same dimensions, given " + globalWorkSizes.length + " vs. " + localWorkSizes.length);
        }
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueNDRangeKernel(queue.getEntity(), this.getEntity(), nDims, Pointer.getPeer(ptrs.sizeT3_1.pointerToSizeTs(globalOffsets)), Pointer.getPeer(ptrs.sizeT3_2.pointerToSizeTs(globalWorkSizes)), Pointer.getPeer(ptrs.sizeT3_3.pointerToSizeTs(localWorkSizes)), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    @Deprecated
    public CLEvent enqueueNDRange(CLQueue queue, int[] globalOffsets, int[] globalWorkSizes, int[] localWorkSizes, CLEvent ... eventsToWaitFor) {
        int nDims = globalWorkSizes.length;
        if (localWorkSizes != null && localWorkSizes.length != nDims) {
            throw new IllegalArgumentException("Global and local sizes must have same dimensions, given " + globalWorkSizes.length + " vs. " + localWorkSizes.length);
        }
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueNDRangeKernel(queue.getEntity(), this.getEntity(), nDims, Pointer.getPeer(ptrs.sizeT3_1.pointerToSizeTs(globalOffsets)), Pointer.getPeer(ptrs.sizeT3_2.pointerToSizeTs(globalWorkSizes)), Pointer.getPeer(ptrs.sizeT3_3.pointerToSizeTs(localWorkSizes)), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    @InfoName(value="CL_KERNEL_NUM_ARGS")
    public int getNumArgs() {
        int numArgs = infos.getInt(this.getEntity(), 4497);
        return numArgs;
    }

    @InfoName(value="CL_KERNEL_FUNCTION_NAME")
    public String getFunctionName() {
        if (this.name == null) {
            this.name = infos.getString(this.getEntity(), 4496);
        }
        return this.name;
    }
}

