/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.IOpenCLLibrary;
import java.util.EnumSet;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLQueue
extends CLAbstractEntity {
    protected static CLInfoGetter infos = new CLInfoGetter(){

        @Override
        protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return JavaCL.CL.clGetCommandQueueInfo(entity, infoTypeEnum, size, Pointer.getPeer(out), Pointer.getPeer(sizeOut));
        }
    };
    final CLContext context;
    final CLDevice device;
    volatile Boolean outOfOrder;

    CLQueue(CLContext context, long entity, CLDevice device) {
        super(entity);
        this.context = context;
        this.device = device;
    }

    public CLContext getContext() {
        return this.context;
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public synchronized boolean isOutOfOrder() {
        if (this.outOfOrder == null) {
            this.outOfOrder = this.getProperties().contains(CLDevice.QueueProperties.OutOfOrderExecModeEnable);
        }
        return this.outOfOrder;
    }

    @InfoName(value="CL_QUEUE_PROPERTIES")
    public EnumSet<CLDevice.QueueProperties> getProperties() {
        return CLDevice.QueueProperties.getEnumSet(infos.getIntOrLong(this.getEntity(), 4243));
    }

    public void setProperty(CLDevice.QueueProperties property, boolean enabled) {
        this.context.getPlatform().requireMinVersionValue("clSetCommandQueueProperty", 1.0, 1.1);
        CLException.error(JavaCL.CL.clSetCommandQueueProperty(this.getEntity(), property.value(), enabled ? 1 : 0, 0L));
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseCommandQueue(this.getEntity()));
    }

    public void finish() {
        CLException.error(JavaCL.CL.clFinish(this.getEntity()));
    }

    public void flush() {
        CLException.error(JavaCL.CL.clFlush(this.getEntity()));
    }

    public void enqueueWaitForEvents(CLEvent ... eventsToWaitFor) {
        this.context.getPlatform().requireMinVersionValue("clEnqueueWaitForEvents", 1.1, 1.2);
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        if (eventsIn == null) {
            return;
        }
        CLException.error(JavaCL.CL.clEnqueueWaitForEvents(this.getEntity(), eventsInCount[0], Pointer.getPeer(eventsIn)));
    }

    public CLEvent enqueueMigrateMemObjects(CLMem[] memObjects, EnumSet<CLMem.Migration> flags, CLEvent ... eventsToWaitFor) {
        this.context.getPlatform().requireMinVersionValue("clEnqueueMigrateMemObjects", 1.2);
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        int[] n = ptrs.int1Array;
        Pointer<SizeT> pMems = CLQueue.pointerToEntities(memObjects, n);
        CLException.error(JavaCL.CL.clEnqueueMigrateMemObjects(this.getEntity(), n[0], Pointer.getPeer(pMems), CLMem.Migration.getValue(flags), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(this, eventOut);
    }

    private static Pointer<SizeT> pointerToEntities(CLAbstractEntity[] entities, int[] n) {
        int nn = 0;
        Pointer<SizeT> pEntities = Pointer.allocateSizeTs(entities.length);
        for (CLAbstractEntity entity : entities) {
            if (entity == null) continue;
            pEntities.setSizeTAtIndex(nn++, entity.getEntity());
        }
        n[0] = nn;
        return pEntities;
    }

    public CLEvent enqueueBarrier(CLEvent ... eventsToWaitFor) {
        if (this.context.getPlatform().getVersionValue() >= 1.2 || eventsToWaitFor != null && eventsToWaitFor.length > 0) {
            this.context.getPlatform().requireMinVersionValue("clEnqueueBarrierWithWaitList", 1.2);
            ReusablePointers ptrs = ReusablePointers.get();
            int[] eventsInCount = ptrs.int1Array;
            Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
            Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
            CLException.error(JavaCL.CL.clEnqueueBarrierWithWaitList(this.getEntity(), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
            return CLEvent.createEventFromPointer(this, eventOut);
        }
        this.context.getPlatform().requireMinVersionValue("clEnqueueBarrier", 1.1, 1.2);
        CLException.error(JavaCL.CL.clEnqueueBarrier(this.getEntity()));
        return null;
    }

    @Deprecated
    public CLEvent enqueueMarker(CLEvent ... eventsToWaitFor) {
        if (this.context.getPlatform().getVersionValue() >= 1.2 || eventsToWaitFor != null && eventsToWaitFor.length > 0) {
            this.context.getPlatform().requireMinVersionValue("clEnqueueMarkerWithWaitList", 1.2);
            ReusablePointers ptrs = ReusablePointers.get();
            int[] eventsInCount = ptrs.int1Array;
            Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
            Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
            CLException.error(JavaCL.CL.clEnqueueMarkerWithWaitList(this.getEntity(), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
            return CLEvent.createEventFromPointer(this, eventOut);
        }
        this.context.getPlatform().requireMinVersionValue("clEnqueueMarker", 1.1, 1.2);
        ReusablePointers ptrs = ReusablePointers.get();
        Pointer<IOpenCLLibrary.cl_event> eventOut = ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueMarker(this.getEntity(), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(this, eventOut);
    }

    public CLEvent enqueueAcquireGLObjects(CLMem[] objects, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer<SizeT> mems = Pointer.allocateSizeTs(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            mems.setSizeTAtIndex(i, objects[i].getEntity());
        }
        CLException.error(JavaCL.CL.clEnqueueAcquireGLObjects(this.getEntity(), objects.length, Pointer.getPeer(mems), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(this, eventOut);
    }

    public CLEvent enqueueReleaseGLObjects(CLMem[] objects, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = ptrs.int1Array;
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<IOpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer mems = CLQueue.getEntities((CLAbstractEntity[])objects, Pointer.allocateSizeTs(objects.length));
        CLException.error(JavaCL.CL.clEnqueueReleaseGLObjects(this.getEntity(), objects.length, Pointer.getPeer(mems), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(this, eventOut);
    }

    public static interface NativeKernel {
        public void execute(Pointer[] var1);
    }
}

