/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.velocity;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Primitive {
    private final Class<?> type;
    private final Class<?> wrapper;
    private final Class<?> bufferType;
    private final String size;
    private final String name;
    private final String capName;
    private final String wrapperName;
    private final String bufferName;
    static List<Primitive> bridJPrimitives;
    static List<Primitive> primitives;
    static List<Primitive> primitivesNoBool;

    public String getCapName() {
        return this.capName;
    }

    public Class<?> getBufferType() {
        return this.bufferType;
    }

    public boolean isSignedIntegral() {
        return this.type == Integer.TYPE || this.type == Short.TYPE || this.type == Long.TYPE || this.type == Byte.TYPE;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeRef() {
        return this.getWrapperName();
    }

    public String getRawTypeRef() {
        return this.getTypeRef();
    }

    public String getSize() {
        return this.size;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getWrapper() {
        return this.wrapper;
    }

    public String getWrapperName() {
        return this.wrapperName;
    }

    public String getBufferName() {
        return this.bufferName;
    }

    public String value(String intValue) {
        return intValue;
    }

    public String rawValue(String intValue) {
        return this.value(intValue);
    }

    public Primitive(String integralClassName) {
        this.type = null;
        this.wrapper = null;
        this.bufferType = null;
        this.size = integralClassName + ".SIZE";
        this.name = integralClassName;
        this.capName = integralClassName;
        this.wrapperName = integralClassName;
        this.bufferName = null;
    }

    public Primitive(Class<?> type) {
        this.type = type;
        if (type == Integer.TYPE) {
            this.wrapper = Integer.class;
            this.bufferType = IntBuffer.class;
            this.size = "4";
        } else if (type == Long.TYPE) {
            this.wrapper = Long.class;
            this.bufferType = LongBuffer.class;
            this.size = "8";
        } else if (type == Short.TYPE) {
            this.wrapper = Short.class;
            this.bufferType = ShortBuffer.class;
            this.size = "2";
        } else if (type == Byte.TYPE) {
            this.wrapper = Byte.class;
            this.bufferType = ByteBuffer.class;
            this.size = "1";
        } else if (type == Character.TYPE) {
            this.wrapper = Character.class;
            this.bufferType = CharBuffer.class;
            this.size = "2";
        } else if (type == Float.TYPE) {
            this.wrapper = Float.class;
            this.bufferType = FloatBuffer.class;
            this.size = "4";
        } else if (type == Double.TYPE) {
            this.wrapper = Double.class;
            this.bufferType = DoubleBuffer.class;
            this.size = "8";
        } else if (type == Boolean.TYPE) {
            this.wrapper = Boolean.class;
            this.bufferType = ByteBuffer.class;
            this.size = "1";
        } else {
            throw new IllegalArgumentException();
        }
        this.name = type.getName();
        this.capName = Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
        this.wrapperName = this.wrapper.getSimpleName();
        this.bufferName = this.bufferType.getSimpleName();
    }

    public static synchronized List<Primitive> getBridJPrimitives() {
        if (bridJPrimitives == null) {
            bridJPrimitives = new ArrayList<Primitive>();
            bridJPrimitives.addAll(Primitive.getPrimitives());
            bridJPrimitives.add(new Primitive("CLong"){

                public String value(String intValue) {
                    return "new CLong(" + intValue + ")";
                }

                public String rawValue(String intValue) {
                    return "(long)" + intValue;
                }
            });
            bridJPrimitives.add(new Primitive("SizeT"){

                public String value(String intValue) {
                    return "new SizeT(" + intValue + ")";
                }

                public String rawValue(String intValue) {
                    return "(long)" + intValue;
                }
            });
            bridJPrimitives.add(new Primitive("Pointer"){

                public String value(String intValue) {
                    return "(Pointer)Pointer.pointerToAddress(" + intValue + ")";
                }

                public String getTypeRef() {
                    return "Pointer<?>";
                }

                public String getRawTypeRef() {
                    return "Pointer";
                }
            });
            bridJPrimitives = Collections.unmodifiableList(bridJPrimitives);
        }
        return bridJPrimitives;
    }

    public static synchronized List<Primitive> getPrimitives() {
        if (primitives == null) {
            primitives = new ArrayList<Primitive>();
            primitives.addAll(Primitive.getPrimitivesNoBool());
            primitives.add(new Primitive((Class)Boolean.TYPE){

                public String value(String intValue) {
                    return "(((" + intValue + ") % 2) == 1)";
                }
            });
            primitives = Collections.unmodifiableList(primitives);
        }
        return primitives;
    }

    public static synchronized List<Primitive> getPrimitivesNoBool() {
        if (primitivesNoBool == null) {
            primitivesNoBool = new ArrayList<Primitive>();
            primitivesNoBool.add(new Primitive((Class)Integer.TYPE){

                public String value(String intValue) {
                    return intValue;
                }
            });
            primitivesNoBool.add(new Primitive((Class)Long.TYPE){

                public String value(String intValue) {
                    return "(long)" + intValue;
                }
            });
            primitivesNoBool.add(new Primitive((Class)Short.TYPE){

                public String value(String intValue) {
                    return "(short)" + intValue;
                }
            });
            primitivesNoBool.add(new Primitive((Class)Byte.TYPE){

                public String value(String intValue) {
                    return "(byte)" + intValue;
                }
            });
            primitivesNoBool.add(new Primitive((Class)Character.TYPE){

                public String value(String intValue) {
                    return "(char)" + intValue;
                }
            });
            primitivesNoBool.add(new Primitive((Class)Float.TYPE){

                public String value(String intValue) {
                    return "(float)" + intValue;
                }
            });
            primitivesNoBool.add(new Primitive((Class)Double.TYPE){

                public String value(String intValue) {
                    return "(double)" + intValue;
                }
            });
            primitivesNoBool = Collections.unmodifiableList(primitivesNoBool);
        }
        return primitivesNoBool;
    }
}

