/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractColumnList;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.thrift.model.ThriftColumnImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ThriftColumnListImpl<C>
extends AbstractColumnList<C> {
    private final List<org.apache.cassandra.thrift.Column> columns;
    private HashMap<C, org.apache.cassandra.thrift.Column> lookup;
    private final Serializer<C> colSer;

    public ThriftColumnListImpl(List<org.apache.cassandra.thrift.Column> columns, Serializer<C> colSer) {
        Preconditions.checkArgument((columns != null ? 1 : 0) != 0, (Object)"Columns must not be null");
        Preconditions.checkArgument((colSer != null ? 1 : 0) != 0, (Object)"Serializer must not be null");
        this.colSer = colSer;
        this.columns = columns;
    }

    public Iterator<Column<C>> iterator() {
        class IteratorImpl
        implements Iterator<Column<C>> {
            Iterator<org.apache.cassandra.thrift.Column> base;

            public IteratorImpl(Iterator<org.apache.cassandra.thrift.Column> base) {
                this.base = base;
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public Column<C> next() {
                org.apache.cassandra.thrift.Column c = this.base.next();
                return new ThriftColumnImpl<Object>(ThriftColumnListImpl.this.colSer.fromBytes(c.getName()), c);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator is immutable");
            }
        }
        return new IteratorImpl(this.columns.iterator());
    }

    public Column<C> getColumnByName(C columnName) {
        this.constructColumnMap();
        org.apache.cassandra.thrift.Column c = this.lookup.get(columnName);
        if (c == null) {
            return null;
        }
        return new ThriftColumnImpl<Object>(this.colSer.fromBytes(c.getName()), c);
    }

    private void constructColumnMap() {
        if (this.lookup == null) {
            this.lookup = Maps.newHashMap();
            for (org.apache.cassandra.thrift.Column column : this.columns) {
                this.lookup.put(this.colSer.fromBytes(column.getName()), column);
            }
        }
    }

    public Column<C> getColumnByIndex(int idx) {
        org.apache.cassandra.thrift.Column c = this.columns.get(idx);
        return new ThriftColumnImpl<Object>(this.colSer.fromBytes(c.getName()), c);
    }

    public C getNameByIndex(int idx) {
        org.apache.cassandra.thrift.Column column = this.columns.get(idx);
        return (C)this.colSer.fromBytes(column.getName());
    }

    public <C2> Column<C2> getSuperColumn(C columnName, Serializer<C2> colSer) {
        throw new UnsupportedOperationException();
    }

    public <C2> Column<C2> getSuperColumn(int idx, Serializer<C2> colSer) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public int size() {
        return this.columns.size();
    }

    public boolean isSuperColumn() {
        return false;
    }

    public Collection<C> getColumnNames() {
        this.constructColumnMap();
        return this.lookup.keySet();
    }
}

