/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class SessionFailRetryLoop
implements Closeable {
    private final CuratorZookeeperClient client;
    private final Mode mode;
    private final Thread ourThread = Thread.currentThread();
    private final AtomicBoolean sessionHasFailed = new AtomicBoolean(false);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final RetryLoop retryLoop;
    private final Watcher watcher = new Watcher(){

        public void process(WatchedEvent watchedEvent) {
            if (watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                SessionFailRetryLoop.this.sessionHasFailed.set(true);
                failedSessionThreads.add(SessionFailRetryLoop.this.ourThread);
            }
        }
    };
    private static final Set<Thread> failedSessionThreads = Sets.newSetFromMap((Map)Maps.newConcurrentMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callWithRetry(CuratorZookeeperClient curatorZookeeperClient, Mode mode, Callable<T> callable) throws Exception {
        T t = null;
        SessionFailRetryLoop sessionFailRetryLoop = curatorZookeeperClient.newSessionFailRetryLoop(mode);
        sessionFailRetryLoop.start();
        try {
            while (sessionFailRetryLoop.shouldContinue()) {
                try {
                    t = callable.call();
                }
                catch (Exception exception) {
                    sessionFailRetryLoop.takeException(exception);
                }
            }
        }
        finally {
            sessionFailRetryLoop.close();
        }
        return t;
    }

    SessionFailRetryLoop(CuratorZookeeperClient curatorZookeeperClient, Mode mode) {
        this.client = curatorZookeeperClient;
        this.mode = mode;
        this.retryLoop = curatorZookeeperClient.newRetryLoop();
    }

    static boolean sessionForThreadHasFailed() {
        return failedSessionThreads.size() > 0 && failedSessionThreads.contains(Thread.currentThread());
    }

    public void start() {
        Preconditions.checkState((boolean)Thread.currentThread().equals(this.ourThread), (Object)"Not in the correct thread");
        this.client.addParentWatcher(this.watcher);
    }

    public boolean shouldContinue() {
        boolean bl = this.isDone.getAndSet(true);
        return !bl;
    }

    @Override
    public void close() {
        Preconditions.checkState((boolean)Thread.currentThread().equals(this.ourThread), (Object)"Not in the correct thread");
        failedSessionThreads.remove(this.ourThread);
        this.client.removeParentWatcher(this.watcher);
    }

    public void takeException(Exception exception) throws Exception {
        Preconditions.checkState((boolean)Thread.currentThread().equals(this.ourThread), (Object)"Not in the correct thread");
        boolean bl = true;
        if (this.sessionHasFailed.get()) {
            switch (this.mode) {
                case RETRY: {
                    this.sessionHasFailed.set(false);
                    failedSessionThreads.remove(this.ourThread);
                    if (!(exception instanceof SessionFailedException)) break;
                    this.isDone.set(false);
                    bl = false;
                    break;
                }
            }
        }
        if (bl) {
            this.retryLoop.takeException(exception);
        }
    }

    public static enum Mode {
        RETRY,
        FAIL;

    }

    public static class SessionFailedException
    extends Exception {
    }
}

