/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;

public class ZKPaths {
    public static String fixForNamespace(String string, String string2) {
        if (string != null) {
            return ZKPaths.makePath(string, string2);
        }
        return string2;
    }

    public static String getNodeFromPath(String string) {
        PathUtils.validatePath((String)string);
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        if (n + 1 >= string.length()) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static PathAndNode getPathAndNode(String string) {
        PathUtils.validatePath((String)string);
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return new PathAndNode(string, "");
        }
        if (n + 1 >= string.length()) {
            return new PathAndNode("/", "");
        }
        String string2 = string.substring(n + 1);
        String string3 = n > 0 ? string.substring(0, n) : "/";
        return new PathAndNode(string3, string2);
    }

    public static void mkdirs(ZooKeeper zooKeeper, String string) throws InterruptedException, KeeperException {
        ZKPaths.mkdirs(zooKeeper, string, true);
    }

    public static void mkdirs(ZooKeeper zooKeeper, String string, boolean bl) throws InterruptedException, KeeperException {
        PathUtils.validatePath((String)string);
        int n = 1;
        do {
            String string2;
            if ((n = string.indexOf(47, n + 1)) == -1) {
                if (!bl) break;
                n = string.length();
            }
            if (zooKeeper.exists(string2 = string.substring(0, n), false) != null) continue;
            try {
                zooKeeper.create(string2, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        } while (n < string.length());
    }

    public static List<String> getSortedChildren(ZooKeeper zooKeeper, String string) throws InterruptedException, KeeperException {
        List list = zooKeeper.getChildren(string, false);
        ArrayList arrayList = Lists.newArrayList((Iterable)list);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static String makePath(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.startsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append(string);
        if (string2 == null || string2.length() == 0) {
            return stringBuilder.toString();
        }
        if (!string.endsWith("/")) {
            stringBuilder.append("/");
        }
        if (string2.startsWith("/")) {
            stringBuilder.append(string2.substring(1));
        } else {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private ZKPaths() {
    }

    public static class PathAndNode {
        private final String path;
        private final String node;

        public PathAndNode(String string, String string2) {
            this.path = string;
            this.node = string2;
        }

        public String getPath() {
            return this.path;
        }

        public String getNode() {
            return this.node;
        }
    }
}

