/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.module.acegi;

import com.octo.captcha.service.sound.SoundCaptchaService;
import java.io.ByteArrayOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class JCaptchaSoundController
implements Controller,
InitializingBean {
    private SoundCaptchaService soundCaptchaService;

    public SoundCaptchaService getSoundCaptchaService() {
        return this.soundCaptchaService;
    }

    public void setSoundCaptchaService(SoundCaptchaService soundCaptchaService) {
        this.soundCaptchaService = soundCaptchaService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.soundCaptchaService == null) {
            throw new RuntimeException("Required soundCaptchaService not set");
        }
    }

    public ModelAndView handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse response) throws Exception {
        AudioInputStream challenge;
        byte[] captchaChallengeAsWav = null;
        ByteArrayOutputStream wavOutputStream = new ByteArrayOutputStream();
        String captchaId = httpServletRequest.getSession().getId();
        AudioInputStream stream = challenge = this.soundCaptchaService.getSoundChallengeForID(captchaId, httpServletRequest.getLocale());
        AudioSystem.write(stream, AudioFileFormat.Type.WAVE, wavOutputStream);
        captchaChallengeAsWav = wavOutputStream.toByteArray();
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("audio/x-wav");
        ServletOutputStream responseOutputStream = response.getOutputStream();
        responseOutputStream.write(captchaChallengeAsWav);
        responseOutputStream.flush();
        responseOutputStream.close();
        return null;
    }
}

