/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.common;

import com.ongres.scram.common.exception.ScramRuntimeException;
import com.ongres.scram.common.util.Preconditions;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;

final class CryptoUtil {
    private CryptoUtil() {
        throw new IllegalStateException("Utility class");
    }

    static byte[] hi(SecretKeyFactory secretKeyFactory, int keyLength, char[] password, byte[] salt, int iterationCount) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterationCount, keyLength);
            SecretKey key = secretKeyFactory.generateSecret(spec);
            spec.clearPassword();
            return key.getEncoded();
        }
        catch (InvalidKeySpecException ex) {
            throw new ScramRuntimeException(String.format(Locale.ROOT, "Platform error: unsupported PBEKeySpec for %s algorithm", secretKeyFactory.getAlgorithm()), ex);
        }
    }

    static byte[] hmac(SecretKeySpec secretKeySpec, Mac mac, byte[] message) {
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException ex) {
            throw new ScramRuntimeException(String.format(Locale.ROOT, "Platform error: unsupported key for %s algorithm", mac.getAlgorithm()), ex);
        }
        return mac.doFinal(message);
    }

    static byte @NotNull [] xor(byte @NotNull [] value1, byte @NotNull [] value2) {
        Preconditions.checkNotNull(value1, "value1");
        Preconditions.checkNotNull(value2, "value2");
        Preconditions.checkArgument(value1.length == value2.length, "Both values must have the same length");
        byte[] result = new byte[value1.length];
        for (int i = 0; i < value1.length; ++i) {
            result[i] = (byte)(value1[i] ^ value2[i]);
        }
        return result;
    }

    static byte @NotNull [] salt(int saltSize, @NotNull SecureRandom random) {
        Preconditions.gt0(saltSize, "saltSize");
        Preconditions.checkNotNull(random, "random");
        byte[] randomSalt = new byte[saltSize];
        random.nextBytes(randomSalt);
        return randomSalt;
    }
}

