/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;

public final class TlsServerEndpoint {
    public static final String TLS_SERVER_END_POINT = "tls-server-end-point";

    private TlsServerEndpoint() {
        throw new IllegalStateException("Utility class");
    }

    private static MessageDigest getDigestAlgorithm(String signatureAlgorithm) {
        int index = signatureAlgorithm.indexOf("with");
        String string = signatureAlgorithm = index > 0 ? signatureAlgorithm.substring(0, index) : "SHA-256";
        if (!signatureAlgorithm.startsWith("SHA3-")) {
            signatureAlgorithm = signatureAlgorithm.replace("SHA", "SHA-");
        }
        if ("MD5".equals(signatureAlgorithm) || "SHA-1".equals(signatureAlgorithm)) {
            signatureAlgorithm = "SHA-256";
        }
        try {
            return MessageDigest.getInstance(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte @NotNull [] getChannelBindingData(@NotNull X509Certificate serverCert) throws CertificateEncodingException {
        MessageDigest digestAlgorithm = TlsServerEndpoint.getDigestAlgorithm(serverCert.getSigAlgName());
        if (digestAlgorithm == null) {
            return new byte[0];
        }
        return digestAlgorithm.digest(serverCert.getEncoded());
    }
}

