/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.common;

import com.ongres.scram.common.CharSupplier;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.util.Preconditions;

enum ScramAttributes implements CharSupplier
{
    USERNAME('n'),
    AUTHZID('a'),
    NONCE('r'),
    CHANNEL_BINDING('c'),
    SALT('s'),
    ITERATION('i'),
    CLIENT_PROOF('p'),
    SERVER_SIGNATURE('v'),
    ERROR('e');

    private final char attributeChar;

    private ScramAttributes(char attributeChar) {
        this.attributeChar = Preconditions.checkNotNull(Character.valueOf(attributeChar), "attributeChar").charValue();
    }

    @Override
    public char getChar() {
        return this.attributeChar;
    }

    public static ScramAttributes byChar(char c) throws ScramParseException {
        switch (c) {
            case 'n': {
                return USERNAME;
            }
            case 'a': {
                return AUTHZID;
            }
            case 'r': {
                return NONCE;
            }
            case 'c': {
                return CHANNEL_BINDING;
            }
            case 's': {
                return SALT;
            }
            case 'i': {
                return ITERATION;
            }
            case 'p': {
                return CLIENT_PROOF;
            }
            case 'v': {
                return SERVER_SIGNATURE;
            }
            case 'e': {
                return ERROR;
            }
        }
        throw new ScramParseException("Attribute with char '" + c + "' does not exist");
    }
}

