/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.common.exception;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ServerErrorValue {
    private static final ConcurrentMap<String, String> ERROR_MESSAGE = ServerErrorValue.initServerErrorValue();

    private ServerErrorValue() {
        throw new IllegalStateException();
    }

    private static ConcurrentMap<String, String> initServerErrorValue() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        map.put("invalid-encoding", "The message format or encoding is incorrect");
        map.put("extensions-not-supported", "Requested extensions are not recognized by the server");
        map.put("invalid-proof", "The client-provided proof is invalid");
        map.put("channel-bindings-dont-match", "Channel bindings sent by the client don't match those expected by the server.");
        map.put("server-does-support-channel-binding", "Server doesn't support channel binding at all.");
        map.put("channel-binding-not-supported", "Channel binding is not supported for this user");
        map.put("unsupported-channel-binding-type", "The requested channel binding type is not supported.");
        map.put("unknown-user", "The specified username is not recognized");
        map.put("invalid-username-encoding", "The username encoding is invalid (either invalid UTF-8 or SASLprep failure)");
        map.put("no-resources", "The server lacks resources to process the request");
        map.put("other-error", "A generic error occurred that doesn't fit into other categories");
        return map;
    }

    public static String getErrorMessage(String errorValue) {
        return (String)ERROR_MESSAGE.get(errorValue);
    }
}

