/*
 * Decompiled with CFR 0.152.
 */
package com.peertopark.java.geocalc;

import com.peertopark.java.geocalc.Coordinate;
import com.peertopark.java.geocalc.DegreeCoordinate;
import java.io.Serializable;

public class Point
implements Serializable {
    protected double latitude;
    protected double longitude;

    public Point(Coordinate latitude, Coordinate longitude) {
        this.latitude = latitude.getValue();
        this.longitude = longitude.getValue();
    }

    public static Point build(Coordinate latitude, Coordinate longitude) {
        return new Point(latitude, longitude);
    }

    public static Point build(Double degreeLatitude, Double degreeLongitude) {
        return new Point(DegreeCoordinate.build(degreeLatitude), DegreeCoordinate.build(degreeLongitude));
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        hash = 31 * hash + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        return hash;
    }

    public String toString() {
        return "Point{latitude=" + this.latitude + ", longitude=" + this.longitude + '}';
    }
}

