/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.DefaultMethodHandleMaker;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.generator.SimpleGenerationStatus;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Random;

public final class Lambdas {
    private Lambdas() {
        throw new UnsupportedOperationException();
    }

    public static <T, U> T makeLambda(Class<T> lambdaType, Generator<U> returnValueGenerator, GenerationStatus status) {
        if (Reflection.singleAbstractMethodOf(lambdaType) == null) {
            throw new IllegalArgumentException(lambdaType + " is not a functional interface type");
        }
        return lambdaType.cast(Proxy.newProxyInstance(lambdaType.getClassLoader(), new Class[]{lambdaType}, new LambdaInvocationHandler<T, U>(lambdaType, returnValueGenerator, status.attempts())));
    }

    private static class LambdaInvocationHandler<T, U>
    implements InvocationHandler {
        private final Class<T> lambdaType;
        private final Generator<U> returnValueGenerator;
        private final int attempts;
        private final DefaultMethodHandleMaker methodHandleMaker = new DefaultMethodHandleMaker();

        LambdaInvocationHandler(Class<T> lambdaType, Generator<U> returnValueGenerator, Integer attempts) {
            this.lambdaType = lambdaType;
            this.returnValueGenerator = returnValueGenerator;
            this.attempts = attempts;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass())) {
                return this.handleObjectMethod(proxy, method, args);
            }
            if (method.isDefault()) {
                return this.handleDefaultMethod(proxy, method, args);
            }
            SourceOfRandomness source = new SourceOfRandomness(new Random());
            source.setSeed(Arrays.hashCode(args));
            SimpleGenerationStatus status = new SimpleGenerationStatus(new GeometricDistribution(), source, this.attempts);
            return this.returnValueGenerator.generate(source, status);
        }

        private Object handleObjectMethod(Object proxy, Method method, Object[] args) {
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            return this.handleToString();
        }

        private String handleToString() {
            return "a randomly generated instance of " + this.lambdaType;
        }

        private Object handleDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
            MethodHandle handle = this.methodHandleMaker.handleForSpecialMethod(method);
            return handle.bindTo(proxy).invokeWithArguments(args);
        }
    }
}

