/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.Produced;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.FakeAnnotatedTypeFactory;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.ReflectionException;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.internal.Zilch;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.javaruntype.type.ExtendsTypeParameter;
import org.javaruntype.type.StandardTypeParameter;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.ConstructorGenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.MethodGenericsContext;

public class ParameterTypeContext {
    private static final String EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE = "The generator %s named in @%s on parameter %s does not produce a type-compatible object";
    private static Zilch zilch;
    private final String parameterName;
    private final AnnotatedType parameterType;
    private final String declarerName;
    private final org.javaruntype.type.Type<?> resolved;
    private final List<Weighted<Generator<?>>> explicits = new ArrayList();
    private final GenericsContext generics;
    private final int parameterIndex;
    private AnnotatedElement annotatedElement;
    private boolean allowMixedTypes;

    public static ParameterTypeContext forClass(Class<?> clazz) {
        return new ParameterTypeContext(clazz.getTypeName(), FakeAnnotatedTypeFactory.makeFrom(clazz), clazz.getTypeName(), Types.forJavaLangReflectType(clazz), GenericsResolver.resolve(clazz, (Class[])new Class[0]));
    }

    public static ParameterTypeContext forField(Field field) {
        GenericsContext generics = GenericsResolver.resolve(field.getDeclaringClass(), (Class[])new Class[0]);
        return new ParameterTypeContext(field.getName(), field.getAnnotatedType(), field.getDeclaringClass().getName(), Types.forJavaLangReflectType((Type)generics.resolveFieldType(field)), generics);
    }

    public static ParameterTypeContext forParameter(Parameter parameter) {
        MethodGenericsContext generics;
        org.javaruntype.type.Type resolved;
        Executable exec = parameter.getDeclaringExecutable();
        Class<?> clazz = exec.getDeclaringClass();
        String declarerName = clazz.getName() + '.' + exec.getName();
        int parameterIndex = ParameterTypeContext.parameterIndex(exec, parameter);
        if (exec instanceof Method) {
            Method method = (Method)exec;
            MethodGenericsContext methodGenerics = GenericsResolver.resolve(clazz, (Class[])new Class[0]).method(method);
            resolved = Types.forJavaLangReflectType((Type)methodGenerics.resolveParameterType(parameterIndex));
            generics = methodGenerics;
        } else if (exec instanceof Constructor) {
            Constructor ctor = (Constructor)exec;
            ConstructorGenericsContext constructorGenerics = GenericsResolver.resolve(clazz, (Class[])new Class[0]).constructor(ctor);
            resolved = Types.forJavaLangReflectType((Type)constructorGenerics.resolveParameterType(parameterIndex));
            generics = constructorGenerics;
        } else {
            throw new IllegalStateException("Unrecognized subtype of Executable");
        }
        return new ParameterTypeContext(parameter.getName(), parameter.getAnnotatedType(), declarerName, resolved, (GenericsContext)generics, parameterIndex);
    }

    public static ParameterTypeContext forParameter(Parameter parameter, MethodGenericsContext generics) {
        Executable exec = parameter.getDeclaringExecutable();
        Class<?> clazz = exec.getDeclaringClass();
        String declarerName = clazz.getName() + '.' + exec.getName();
        int parameterIndex = ParameterTypeContext.parameterIndex(exec, parameter);
        return new ParameterTypeContext(parameter.getName(), parameter.getAnnotatedType(), declarerName, Types.forJavaLangReflectType((Type)generics.resolveParameterType(parameterIndex)), (GenericsContext)generics, parameterIndex);
    }

    private static int parameterIndex(Executable exec, Parameter parameter) {
        Parameter[] parameters = exec.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].equals(parameter)) continue;
            return i;
        }
        throw new IllegalStateException("Cannot find parameter " + parameter + " on " + exec);
    }

    private ParameterTypeContext(String parameterName, AnnotatedType parameterType, String declarerName, org.javaruntype.type.Type<?> resolvedType, GenericsContext generics) {
        this(parameterName, parameterType, declarerName, resolvedType, generics, -1);
    }

    private ParameterTypeContext(String parameterName, AnnotatedType parameterType, String declarerName, org.javaruntype.type.Type<?> resolvedType, GenericsContext generics, int parameterIndex) {
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.declarerName = declarerName;
        this.resolved = resolvedType;
        this.generics = generics;
        this.parameterIndex = parameterIndex;
    }

    public ParameterTypeContext annotate(AnnotatedElement element) {
        List<From> generators;
        this.annotatedElement = element;
        List<Produced> producedGenerators = Reflection.allAnnotationsByType(element, Produced.class);
        if (producedGenerators.size() == 1) {
            generators = Arrays.asList(producedGenerators.get(0).value());
        } else {
            generators = Reflection.allAnnotationsByType(element, From.class);
            if (!generators.isEmpty() && element instanceof AnnotatedWildcardType) {
                throw new IllegalArgumentException("Wildcards cannot be marked with @From");
            }
        }
        this.addGenerators(generators);
        return this;
    }

    public ParameterTypeContext allowMixedTypes(boolean value) {
        this.allowMixedTypes = value;
        return this;
    }

    public boolean allowMixedTypes() {
        return this.allowMixedTypes;
    }

    public ParameterTypeContext methodReturnTypeContext(Method method) {
        if (!(this.generics instanceof MethodGenericsContext)) {
            throw new IllegalStateException("invoking methodReturnTypeContext in present of " + this.generics);
        }
        MethodGenericsContext testMethodGenerics = (MethodGenericsContext)this.generics;
        MethodGenericsContext argMethodGenerics = testMethodGenerics.parameterType(this.parameterIndex).method(method);
        return new ParameterTypeContext("return value", method.getAnnotatedReturnType(), method.getName(), Types.forJavaLangReflectType((Type)argMethodGenerics.resolveReturnType()), (GenericsContext)argMethodGenerics);
    }

    private void addGenerators(List<From> generators) {
        for (From each : generators) {
            Generator<?> generator = this.makeGenerator(each.value());
            this.ensureCorrectType(generator);
            this.explicits.add(new Weighted(generator, each.frequency()));
        }
    }

    private Generator<?> makeGenerator(Class<? extends Generator> generatorType) {
        Constructor<? extends Generator> ctor;
        try {
            ctor = Reflection.findConstructor(generatorType, Class.class);
        }
        catch (ReflectionException ex) {
            return Reflection.instantiate(generatorType);
        }
        return Reflection.instantiate(ctor, this.rawParameterType());
    }

    private Class<?> rawParameterType() {
        if (this.type() instanceof ParameterizedType) {
            return this.resolved.getRawClass();
        }
        if (this.type() instanceof TypeVariable) {
            return this.resolved.getRawClass();
        }
        return (Class)this.type();
    }

    private void ensureCorrectType(Generator<?> generator) {
        for (Class<?> each : generator.types()) {
            if (Reflection.maybeWrap(this.resolved.getRawClass()).isAssignableFrom(Reflection.maybeWrap(each))) continue;
            throw new IllegalArgumentException(String.format(EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE, each, From.class.getName(), this.parameterName));
        }
    }

    public String name() {
        return this.declarerName + ':' + this.parameterName;
    }

    public AnnotatedType annotatedType() {
        return this.parameterType;
    }

    public Type type() {
        return this.parameterType.getType();
    }

    @Deprecated
    public AnnotatedElement annotatedElement() {
        return this.annotatedElement;
    }

    @Deprecated
    public boolean topLevel() {
        return this.annotatedElement instanceof Parameter || this.annotatedElement instanceof Field;
    }

    public List<Weighted<Generator<?>>> explicitGenerators() {
        return Collections.unmodifiableList(this.explicits);
    }

    public ParameterTypeContext arrayComponentContext() {
        org.javaruntype.type.Type component = Types.arrayComponentOf(this.resolved);
        AnnotatedType annotatedComponent = this.annotatedArrayComponent(component);
        return new ParameterTypeContext(annotatedComponent.getType().getTypeName(), annotatedComponent, this.parameterType.getType().getTypeName(), component, this.generics).annotate(annotatedComponent).allowMixedTypes(true);
    }

    private AnnotatedType annotatedArrayComponent(org.javaruntype.type.Type<?> component) {
        return this.parameterType instanceof AnnotatedArrayType ? ((AnnotatedArrayType)this.parameterType).getAnnotatedGenericComponentType() : FakeAnnotatedTypeFactory.makeFrom(component.getComponentClass());
    }

    public boolean isArray() {
        return this.resolved.isArray();
    }

    public Class<?> getRawClass() {
        return this.resolved.getRawClass();
    }

    public boolean isEnum() {
        return this.getRawClass().isEnum();
    }

    public List<TypeParameter<?>> getTypeParameters() {
        return this.resolved.getTypeParameters();
    }

    public List<ParameterTypeContext> typeParameterContexts(SourceOfRandomness random) {
        ArrayList<ParameterTypeContext> typeParamContexts = new ArrayList<ParameterTypeContext>();
        List<TypeParameter<?>> typeParameters = this.getTypeParameters();
        List<AnnotatedType> annotatedTypeParameters = Reflection.annotatedComponentTypes(this.annotatedType());
        for (int i = 0; i < typeParameters.size(); ++i) {
            AnnotatedType a;
            TypeParameter<?> p = typeParameters.get(i);
            AnnotatedType annotatedType = a = annotatedTypeParameters.size() > i ? annotatedTypeParameters.get(i) : ParameterTypeContext.zilch();
            if (p instanceof StandardTypeParameter) {
                this.addStandardTypeParameterContext(typeParamContexts, p, a);
                continue;
            }
            if (p instanceof WildcardTypeParameter) {
                this.addWildcardTypeParameterContext(typeParamContexts, a);
                continue;
            }
            if (p instanceof ExtendsTypeParameter) {
                this.addExtendsTypeParameterContext(typeParamContexts, p, a);
                continue;
            }
            this.addSuperTypeParameterContext(random, typeParamContexts, p, a);
        }
        return typeParamContexts;
    }

    private void addStandardTypeParameterContext(List<ParameterTypeContext> typeParameterContexts, TypeParameter<?> p, AnnotatedType a) {
        typeParameterContexts.add(new ParameterTypeContext(p.getType().getName(), a, this.annotatedType().getType().getTypeName(), p.getType(), this.generics).allowMixedTypes(!(a instanceof TypeVariable)).annotate(a));
    }

    private void addWildcardTypeParameterContext(List<ParameterTypeContext> typeParameterContexts, AnnotatedType a) {
        typeParameterContexts.add(new ParameterTypeContext("Zilch", a, this.annotatedType().getType().getTypeName(), Types.forJavaLangReflectType(Zilch.class), GenericsResolver.resolve(Zilch.class, (Class[])new Class[0])).allowMixedTypes(true).annotate(a));
    }

    private void addExtendsTypeParameterContext(List<ParameterTypeContext> typeParameterContexts, TypeParameter<?> p, AnnotatedType a) {
        typeParameterContexts.add(new ParameterTypeContext(p.getType().getName(), Reflection.annotatedComponentTypes(a).get(0), this.annotatedType().getType().getTypeName(), p.getType(), this.generics).allowMixedTypes(false).annotate(a));
    }

    private void addSuperTypeParameterContext(SourceOfRandomness random, List<ParameterTypeContext> typeParameterContexts, TypeParameter<?> p, AnnotatedType a) {
        Set<org.javaruntype.type.Type<?>> supertypes = Reflection.supertypes(p.getType());
        org.javaruntype.type.Type<?> choice = Items.choose(supertypes, random);
        typeParameterContexts.add(new ParameterTypeContext(p.getType().getName(), Reflection.annotatedComponentTypes(a).get(0), this.annotatedType().getType().getTypeName(), choice, this.generics).allowMixedTypes(false).annotate(a));
    }

    private static AnnotatedType zilch() {
        try {
            return ParameterTypeContext.class.getDeclaredField("zilch").getAnnotatedType();
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

