/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.sampling;

import com.pholser.junit.quickcheck.conversion.StringConversion;
import com.pholser.junit.quickcheck.generator.Also;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Only;
import com.pholser.junit.quickcheck.internal.CartesianIterator;
import com.pholser.junit.quickcheck.internal.ParameterSampler;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.SeededValue;
import com.pholser.junit.quickcheck.internal.conversion.StringConversions;
import com.pholser.junit.quickcheck.internal.generator.ExhaustiveDomainGenerator;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.GuaranteeValuesGenerator;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ExhaustiveParameterSampler
implements ParameterSampler {
    private final int sizeFactor;

    public ExhaustiveParameterSampler(int sizeFactor) {
        this.sizeFactor = sizeFactor;
    }

    @Override
    public int sizeFactor(ParameterTypeContext p) {
        Only only = p.annotatedType().getAnnotation(Only.class);
        if (only != null) {
            return new HashSet<String>(Arrays.asList(only.value())).size();
        }
        Also also = p.annotatedType().getAnnotation(Also.class);
        if (also != null) {
            return Math.max(this.sizeFactor, new HashSet<String>(Arrays.asList(also.value())).size());
        }
        if (Boolean.class.equals(Reflection.maybeWrap(p.getRawClass()))) {
            return 2;
        }
        if (p.isEnum()) {
            return Array.getLength(Reflection.invoke(Reflection.findMethod(p.getRawClass(), "values", new Class[0]), null, new Object[0]));
        }
        return this.sizeFactor;
    }

    @Override
    public Stream<List<SeededValue>> sample(List<PropertyParameterGenerationContext> parameters) {
        List sources = parameters.stream().map(p -> Stream.generate(() -> new SeededValue((PropertyParameterGenerationContext)p)).limit(p.sampleSize()).iterator()).collect(Collectors.toList());
        return this.cartesian(sources);
    }

    @Override
    public Generator<?> decideGenerator(GeneratorRepository repository, ParameterTypeContext p) {
        Only only = p.annotatedType().getAnnotation(Only.class);
        if (only != null) {
            StringConversion conversion = StringConversions.decide(p, only);
            Set values = Arrays.stream(only.value()).map(conversion::convert).collect(Collectors.toSet());
            return new ExhaustiveDomainGenerator(values);
        }
        Also also = p.annotatedType().getAnnotation(Also.class);
        if (also != null) {
            StringConversion conversion = StringConversions.decide(p, also);
            Set values = Arrays.stream(also.value()).map(conversion::convert).collect(Collectors.toSet());
            return new GuaranteeValuesGenerator(new ExhaustiveDomainGenerator(values), repository.produceGenerator(p));
        }
        if (Boolean.class.equals(Reflection.maybeWrap(p.getRawClass()))) {
            return new ExhaustiveDomainGenerator((Collection<?>)Arrays.asList(true, false));
        }
        if (p.isEnum()) {
            return new ExhaustiveDomainGenerator((Collection<?>)Arrays.asList(p.getRawClass().getEnumConstants()));
        }
        return repository.produceGenerator(p);
    }

    private <T> Stream<List<T>> cartesian(List<Iterator<T>> sources) {
        Iterable cartesian = () -> new CartesianIterator(sources);
        return StreamSupport.stream(cartesian.spliterator(), false);
    }
}

