/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.runner.PropertyFalsified;
import com.pholser.junit.quickcheck.runner.PropertyVerifier;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

final class ShrinkNode
implements Comparable<ShrinkNode> {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final List<PropertyParameterGenerationContext> params;
    private final Object[] args;
    private final long[] seeds;
    private final int[] depths;
    private final int totalDepth;
    private final BigDecimal totalMagnitude;
    private AssertionError failure;

    private ShrinkNode(FrameworkMethod method, TestClass testClass, List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, int[] depths, AssertionError failure) {
        this.method = method;
        this.testClass = testClass;
        this.params = params;
        this.args = args;
        this.seeds = seeds;
        this.depths = depths;
        this.totalDepth = IntStream.of(depths).sum();
        this.totalMagnitude = this.computeTotalMagnitude();
        this.failure = failure;
    }

    static ShrinkNode root(FrameworkMethod method, TestClass testClass, List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, AssertionError failure) {
        return new ShrinkNode(method, testClass, params, args, seeds, new int[args.length], failure);
    }

    List<ShrinkNode> shrinks() {
        return IntStream.range(0, this.params.size()).mapToObj(i -> this.params.get(i).shrink(this.args[i]).stream().filter(o -> !o.equals(this.args[i])).map(o -> this.shrinkNodeFor(o, i))).flatMap(Function.identity()).collect(Collectors.toList());
    }

    boolean verifyProperty() throws Throwable {
        boolean[] result = new boolean[1];
        this.property(result).verify();
        return result[0];
    }

    AssertionError fail(AssertionError originalFailure, Object[] originalArgs) {
        return originalFailure == this.failure ? PropertyFalsified.counterexampleFound(this.method.getName(), this.args, this.seeds, this.failure) : PropertyFalsified.smallerCounterexampleFound(this.method.getName(), originalArgs, this.args, this.seeds, this.failure, originalFailure);
    }

    Object[] args() {
        return this.args;
    }

    int depth() {
        return this.totalDepth;
    }

    BigDecimal magnitude() {
        return this.totalMagnitude;
    }

    private PropertyVerifier property(boolean[] result) throws InitializationError {
        return new PropertyVerifier(this.testClass, this.method, this.args, this.seeds, s -> {
            result[0] = true;
        }, v -> {
            result[0] = true;
        }, (e, repeatTestOption) -> {
            this.failure = e;
            result[0] = false;
        });
    }

    private ShrinkNode shrinkNodeFor(Object shrunk, int index) {
        Object[] shrunkArgs = new Object[this.args.length];
        System.arraycopy(this.args, 0, shrunkArgs, 0, this.args.length);
        shrunkArgs[index] = shrunk;
        int[] newDepths = new int[this.depths.length];
        System.arraycopy(this.depths, 0, newDepths, 0, this.depths.length);
        int n = index;
        newDepths[n] = newDepths[n] + 1;
        return new ShrinkNode(this.method, this.testClass, this.params, shrunkArgs, this.seeds, newDepths, this.failure);
    }

    private BigDecimal computeTotalMagnitude() {
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < this.args.length; ++i) {
            BigDecimal magnitude = this.magnitudeAt(i);
            BigDecimal factor = BigDecimal.valueOf(2L).pow(this.args.length - i - 1);
            total = total.add(magnitude.multiply(factor));
        }
        return total;
    }

    private BigDecimal magnitudeAt(int index) {
        return this.params.get(index).magnitude(this.args[index]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ShrinkNode)) {
            return false;
        }
        ShrinkNode other = (ShrinkNode)o;
        return Arrays.equals(this.args, other.args) && Arrays.equals(this.depths, other.depths);
    }

    public int hashCode() {
        return Arrays.hashCode(this.args) ^ Arrays.hashCode(this.depths);
    }

    @Override
    public int compareTo(ShrinkNode other) {
        Comparator<ShrinkNode> comparison = Comparator.comparing(ShrinkNode::depth);
        int i = 0;
        while (i < this.params.size()) {
            int index = i++;
            Comparator<ShrinkNode> byMagnitude = Comparator.comparing(s -> s.magnitudeAt(index));
            comparison = comparison.thenComparing(byMagnitude.reversed());
        }
        return comparison.compare(this, other);
    }
}

