/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.IntegralImage;
import com.stromberglabs.jopensurf.ResponseLayer;
import com.stromberglabs.jopensurf.SURFInterestPoint;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class FastHessian
implements Serializable {
    private static final long serialVersionUID = 5739910362000974014L;
    private static int[][] filter_map = new int[][]{{0, 1, 2, 3}, {1, 3, 4, 5}, {3, 5, 6, 7}, {5, 7, 8, 9}, {7, 9, 10, 11}};
    private IntegralImage mIntegralImage;
    private List<SURFInterestPoint> mInterestPoints;
    private int mOctaves;
    private int mInitSample;
    private float mThreshold;
    private int mHeight;
    private int mWidth;
    private boolean mRecalculateInterestPoints = true;
    List<ResponseLayer> mLayers;

    public FastHessian(IntegralImage integralImage, int octaves, int initSample, float threshold, float balanceValue) {
        this.mIntegralImage = integralImage;
        this.mOctaves = octaves;
        this.mInitSample = initSample;
        this.mThreshold = threshold;
        this.mWidth = integralImage.getWidth();
        this.mHeight = integralImage.getHeight();
    }

    public List<SURFInterestPoint> getIPoints() {
        if (this.mInterestPoints == null || this.mRecalculateInterestPoints) {
            this.mInterestPoints = new LinkedList<SURFInterestPoint>();
            this.buildResponseMap();
            for (int o = 0; o < this.mOctaves; ++o) {
                for (int i = 0; i <= 1; ++i) {
                    ResponseLayer b = this.mLayers.get(filter_map[o][i]);
                    ResponseLayer m = this.mLayers.get(filter_map[o][i + 1]);
                    ResponseLayer t = this.mLayers.get(filter_map[o][i + 2]);
                    for (int r = 0; r < t.getHeight(); ++r) {
                        for (int c = 0; c < t.getWidth(); ++c) {
                            SURFInterestPoint point;
                            if (!this.isExtremum(r, c, t, m, b) || (point = this.interpolateExtremum(r, c, t, m, b)) == null) continue;
                            this.mInterestPoints.add(point);
                        }
                    }
                }
            }
        }
        return this.mInterestPoints;
    }

    private void buildResponseMap() {
        this.mLayers = new LinkedList<ResponseLayer>();
        int w = this.mWidth / this.mInitSample;
        int h = this.mHeight / this.mInitSample;
        int s = this.mInitSample;
        if (this.mOctaves >= 1) {
            this.mLayers.add(new ResponseLayer(w, h, s, 9, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(w, h, s, 15, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(w, h, s, 21, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(w, h, s, 27, this.mIntegralImage));
        }
        if (this.mOctaves >= 2) {
            this.mLayers.add(new ResponseLayer(w / 2, h / 2, s * 2, 39, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(w / 2, h / 2, s * 2, 51, this.mIntegralImage));
        }
        if (this.mOctaves >= 3) {
            this.mLayers.add(new ResponseLayer(w / 4, h / 4, s * 4, 75, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(w / 4, h / 4, s * 4, 99, this.mIntegralImage));
        }
        if (this.mOctaves >= 4) {
            this.mLayers.add(new ResponseLayer(w / 8, h / 8, s * 8, 147, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(w / 8, h / 8, s * 8, 195, this.mIntegralImage));
        }
        if (this.mOctaves >= 5) {
            this.mLayers.add(new ResponseLayer(w / 16, h / 16, s * 16, 291, this.mIntegralImage));
            this.mLayers.add(new ResponseLayer(w / 16, h / 16, s * 16, 387, this.mIntegralImage));
        }
    }

    private boolean isExtremum(int r, int c, ResponseLayer t, ResponseLayer m, ResponseLayer b) {
        int layerBorder = (t.getFilter() + 1) / (2 * t.getStep());
        if (r <= layerBorder || r >= t.getHeight() - layerBorder || c <= layerBorder || c >= t.getWidth() - layerBorder) {
            return false;
        }
        double candidate = m.getResponse(r, c, t);
        if (candidate < (double)this.mThreshold) {
            return false;
        }
        for (int rr = -1; rr <= 1; ++rr) {
            for (int cc = -1; cc <= 1; ++cc) {
                if (!(t.getResponse(r + rr, c + cc) >= candidate) && (rr == 0 && cc == 0 || !(m.getResponse(r + rr, c + cc, t) >= candidate)) && !(b.getResponse(r + rr, c + cc, t) >= candidate)) continue;
                return false;
            }
        }
        return true;
    }

    private SURFInterestPoint interpolateExtremum(int r, int c, ResponseLayer t, ResponseLayer m, ResponseLayer b) {
        int filterStep = m.getFilter() - b.getFilter();
        double xi = 0.0;
        double xr = 0.0;
        double xc = 0.0;
        double[] values = this.interpolateStep(r, c, t, m, b);
        xi = values[0];
        xr = values[1];
        xc = values[2];
        if (Math.abs(xi) < 0.5 && Math.abs(xr) < 0.5 && Math.abs(xc) < 0.5) {
            float x = (float)((double)c + xc) * (float)t.getStep();
            float y = (float)((double)r + xr) * (float)t.getStep();
            float scale = (float)((double)0.1333f * ((double)m.getFilter() + xi * (double)filterStep));
            int laplacian = (int)m.getLaplacian(r, c, t);
            return new SURFInterestPoint(x, y, scale, laplacian);
        }
        return null;
    }

    private double[] interpolateStep(int r, int c, ResponseLayer t, ResponseLayer m, ResponseLayer b) {
        double[] values = new double[3];
        RealMatrix partialDerivs = this.getPartialDerivativeMatrix(r, c, t, m, b);
        RealMatrix hessian3D = this.getHessian3DMatrix(r, c, t, m, b);
        DecompositionSolver solver = new LUDecomposition(hessian3D).getSolver();
        RealMatrix X = solver.getInverse().multiply(partialDerivs);
        values[0] = -X.getEntry(2, 0);
        values[1] = -X.getEntry(1, 0);
        values[2] = -X.getEntry(0, 0);
        return values;
    }

    private RealMatrix getPartialDerivativeMatrix(int r, int c, ResponseLayer t, ResponseLayer m, ResponseLayer b) {
        double[][] derivs = new double[3][1];
        derivs[0][0] = (m.getResponse(r, c + 1, t) - m.getResponse(r, c - 1, t)) / 2.0;
        derivs[1][0] = (m.getResponse(r + 1, c, t) - m.getResponse(r - 1, c, t)) / 2.0;
        derivs[2][0] = (t.getResponse(r, c) - b.getResponse(r, c, t)) / 2.0;
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(derivs);
        return matrix;
    }

    private RealMatrix getHessian3DMatrix(int r, int c, ResponseLayer t, ResponseLayer m, ResponseLayer b) {
        double[][] hessian = new double[3][3];
        double v = m.getResponse(r, c, t);
        hessian[0][0] = m.getResponse(r, c + 1, t) + m.getResponse(r, c - 1, t) - 2.0 * v;
        hessian[1][1] = m.getResponse(r + 1, c, t) + m.getResponse(r - 1, c, t) - 2.0 * v;
        hessian[2][2] = t.getResponse(r, c) + b.getResponse(r, c, t) - 2.0 * v;
        double d = (m.getResponse(r + 1, c + 1, t) - m.getResponse(r + 1, c - 1, t) - m.getResponse(r - 1, c + 1, t) + m.getResponse(r - 1, c - 1, t)) / 4.0;
        hessian[1][0] = d;
        hessian[0][1] = d;
        double d2 = (t.getResponse(r, c + 1) - t.getResponse(r, c - 1) - b.getResponse(r, c + 1, t) + b.getResponse(r, c - 1, t)) / 4.0;
        hessian[2][0] = d2;
        hessian[0][2] = d2;
        double d3 = (t.getResponse(r + 1, c) - t.getResponse(r - 1, c) - b.getResponse(r + 1, c, t) + b.getResponse(r - 1, c, t)) / 4.0;
        hessian[2][1] = d3;
        hessian[1][2] = d3;
        return new Array2DRowRealMatrix(hessian);
    }

    public static void main(String[] args) {
        try {
            IntegralImage integralImage = new IntegralImage(ImageIO.read(new File("C:\\workspace\\opensurf\\OpenSURF\\Images\\sf.jpg")));
            FastHessian hessian = new FastHessian(integralImage, 5, 2, 0.004f, 0.81f);
            hessian.getIPoints();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

