/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.ImageTransformUtils;
import com.stromberglabs.jopensurf.IntegralImage;
import java.io.Serializable;

public class ResponseLayer
implements Serializable {
    private static final long serialVersionUID = -6212835326065799379L;
    private int mWidth;
    private int mHeight;
    private int mStep;
    private int mFilter;
    private char[][] mLaplacian;
    private double[][] mResponses;

    ResponseLayer(int width, int height, int step, int filter, IntegralImage integralImage) {
        this.mWidth = width;
        this.mHeight = height;
        this.mStep = step;
        this.mFilter = filter;
        this.mLaplacian = new char[this.mWidth][this.mHeight];
        this.mResponses = new double[this.mWidth][this.mHeight];
        this.buildResponseLayer(integralImage);
    }

    private void buildResponseLayer(IntegralImage img) {
        int b = (this.mFilter - 1) / 2 + 1;
        int l = this.mFilter / 3;
        int w = this.mFilter;
        double inverse_area = 1.0 / (double)(w * w);
        int index = 0;
        for (int ar = 0; ar < this.mHeight; ++ar) {
            int ac = 0;
            while (ac < this.mWidth) {
                int r = ar * this.mStep;
                int c = ac * this.mStep;
                double Dxx = ImageTransformUtils.BoxIntegral(img, r - l + 1, c - b, 2 * l - 1, w) - ImageTransformUtils.BoxIntegral(img, r - l + 1, c - l / 2, 2 * l - 1, l) * 3.0f;
                double Dyy = ImageTransformUtils.BoxIntegral(img, r - b, c - l + 1, w, 2 * l - 1) - ImageTransformUtils.BoxIntegral(img, r - l / 2, c - l + 1, l, 2 * l - 1) * 3.0f;
                double Dxy = ImageTransformUtils.BoxIntegral(img, r - l, c + 1, l, l) + ImageTransformUtils.BoxIntegral(img, r + 1, c - l, l, l) - ImageTransformUtils.BoxIntegral(img, r - l, c - l, l, l) - ImageTransformUtils.BoxIntegral(img, r + 1, c + 1, l, l);
                this.mResponses[ac][ar] = (Dxx *= inverse_area) * (Dyy *= inverse_area) - (double)0.81f * (Dxy *= inverse_area) * Dxy;
                this.mLaplacian[ac][ar] = (char)(Dxx + Dyy >= 0.0 ? 1 : 0);
                ++ac;
                ++index;
            }
        }
    }

    public double getResponse(int row, int col) {
        return this.mResponses[col][row];
    }

    public char getLaplacian(int row, int col) {
        return this.mLaplacian[col][row];
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getFilter() {
        return this.mFilter;
    }

    public int getStep() {
        return this.mStep;
    }

    public double getResponse(int row, int col, ResponseLayer src) {
        int scale = this.getWidth() / src.getWidth();
        return this.getResponse(row * scale, col * scale);
    }

    public float getLaplacian(int row, int col, ResponseLayer src) {
        int scale = this.getWidth() / src.getWidth();
        return this.getLaplacian(row * scale, col * scale);
    }
}

