/*
 * Decompiled with CFR 0.152.
 */
package com.stromberglabs.jopensurf;

import com.stromberglabs.jopensurf.SURFInterestPoint;
import com.stromberglabs.jopensurf.Surf;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SurfCompare
extends JPanel {
    private static final long serialVersionUID = 1433189931871871332L;
    private static final int BASE_CIRCLE_DIAMETER = 8;
    private static final int TARGET_CIRCLE_DIAMETER = 4;
    private static final int UNMATCHED_CIRCLE_DIAMETER = 4;
    private BufferedImage image;
    private BufferedImage imageB;
    private float mImageAXScale = 0.0f;
    private float mImageAYScale = 0.0f;
    private float mImageBXScale = 0.0f;
    private float mImageBYScale = 0.0f;
    private int mImageAWidth = 0;
    private int mImageAHeight = 0;
    private int mImageBWidth = 0;
    private int mImageBHeight = 0;
    private Surf mSurfA;
    private Surf mSurfB;
    private Map<SURFInterestPoint, SURFInterestPoint> mAMatchingPoints;
    private Map<SURFInterestPoint, SURFInterestPoint> mBMatchingPoints;
    private boolean mUpright = false;

    public SurfCompare(BufferedImage image, BufferedImage imageB) {
        this.image = image;
        this.imageB = imageB;
        this.mSurfA = new Surf(image);
        this.mSurfB = new Surf(imageB);
        this.mImageAXScale = (float)Math.min(image.getWidth(), 800) / (float)image.getWidth();
        this.mImageAYScale = Math.min((float)image.getHeight(), 800.0f * (float)image.getHeight() / (float)image.getWidth()) / (float)image.getHeight();
        this.mImageBXScale = (float)Math.min(imageB.getWidth(), 800) / (float)imageB.getWidth();
        this.mImageBYScale = Math.min((float)imageB.getHeight(), 800.0f * (float)imageB.getHeight() / (float)imageB.getWidth()) / (float)imageB.getHeight();
        this.mImageAWidth = (int)((float)image.getWidth() * this.mImageAXScale);
        this.mImageAHeight = (int)((float)image.getHeight() * this.mImageAYScale);
        this.mImageBWidth = (int)((float)imageB.getWidth() * this.mImageBXScale);
        this.mImageBHeight = (int)((float)image.getHeight() * this.mImageBYScale);
        this.mAMatchingPoints = this.mSurfA.getMatchingPoints(this.mSurfB, this.mUpright);
        this.mBMatchingPoints = this.mSurfB.getMatchingPoints(this.mSurfA, this.mUpright);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.image, 0, 0, this.mImageAWidth, this.mImageAHeight, this);
        g.drawImage(this.imageB, this.mImageAWidth, 0, this.mImageBWidth, this.mImageBHeight, Color.WHITE, this);
        if (this.mSurfA != null && this.mSurfB != null) {
            this.drawIpoints(g, this.mUpright ? this.mSurfA.getUprightInterestPoints() : this.mSurfA.getFreeOrientedInterestPoints(), 0, this.mImageAXScale, this.mImageAYScale);
            this.drawIpoints(g, this.mUpright ? this.mSurfB.getUprightInterestPoints() : this.mSurfB.getFreeOrientedInterestPoints(), this.mImageAWidth, this.mImageBXScale, this.mImageBYScale);
            this.drawConnectingPoints(g);
        }
    }

    private void drawIpoints(Graphics g, List<SURFInterestPoint> points, int offset, float xScale, float yScale) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.RED);
        for (SURFInterestPoint point : points) {
            if (this.mAMatchingPoints.containsKey(point) || this.mBMatchingPoints.containsKey(point)) continue;
            int x = (int)(xScale * point.getX()) + offset;
            int y = (int)(yScale * point.getY());
            g2d.drawOval(x - 2, y - 2, 4, 4);
        }
    }

    private void drawConnectingPoints(Graphics g) {
        int ty;
        int tx;
        SURFInterestPoint target;
        int y;
        int x;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.GREEN);
        int offset = this.mImageAWidth;
        for (SURFInterestPoint point : this.mAMatchingPoints.keySet()) {
            x = (int)(this.mImageAXScale * point.getX());
            y = (int)(this.mImageAYScale * point.getY());
            g2d.drawOval(x - 4, y - 4, 8, 8);
            target = this.mAMatchingPoints.get(point);
            tx = (int)(this.mImageBXScale * target.getX()) + offset;
            ty = (int)(this.mImageBYScale * target.getY());
            g2d.drawOval(tx - 2, ty - 2, 4, 4);
            g2d.drawLine(x, y, tx, ty);
        }
        g2d.setColor(Color.BLUE);
        for (SURFInterestPoint point : this.mBMatchingPoints.keySet()) {
            x = (int)(this.mImageBXScale * point.getX()) + offset;
            y = (int)(this.mImageBYScale * point.getY());
            g2d.drawOval(x - 4, y - 4, 8, 8);
            target = this.mBMatchingPoints.get(point);
            tx = (int)(this.mImageAXScale * target.getX());
            ty = (int)(this.mImageAYScale * target.getY());
            g2d.drawOval(tx - 2, ty - 2, 4, 4);
            g2d.drawLine(x, y, tx, ty);
        }
    }

    public void display() {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.add(new JScrollPane(this));
        f.setSize(this.mImageAWidth + this.mImageBWidth, Math.max(this.mImageAHeight, this.mImageBHeight));
        f.setLocation(0, 0);
        f.setVisible(true);
    }

    public void matchesInfo() {
        Map<SURFInterestPoint, SURFInterestPoint> pointsA = this.mSurfA.getMatchingPoints(this.mSurfB, true);
        Map<SURFInterestPoint, SURFInterestPoint> pointsB = this.mSurfB.getMatchingPoints(this.mSurfA, true);
        System.out.println("There are: " + pointsA.size() + " matching points of " + this.mSurfA.getUprightInterestPoints().size());
        System.out.println("There are: " + pointsB.size() + " matching points of " + this.mSurfB.getUprightInterestPoints().size());
    }

    public static void main(String[] args) throws IOException {
        BufferedImage imageA = ImageIO.read(new File(args[0]));
        BufferedImage imageB = ImageIO.read(new File(args[1]));
        SurfCompare show = new SurfCompare(imageA, imageB);
        show.display();
    }
}

