/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CLevel;
import com.thinkaurelius.titan.diskstorage.cassandra.CassandraTransaction;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProviders;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class CassandraTransactionTest {
    @Test
    public void testWriteConsistencyLevel() {
        int levelsChecked = 0;
        for (CLevel writeLevel : CLevel.values()) {
            StandardBaseTransactionConfig.Builder b = new StandardBaseTransactionConfig.Builder();
            ModifiableConfiguration mc = GraphDatabaseConfiguration.buildGraphConfiguration();
            mc.set(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY, (Object)writeLevel.name(), new String[0]);
            b.customOptions((Configuration)mc);
            b.timestampProvider((TimestampProvider)TimestampProviders.MICRO);
            CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)b.build());
            Assert.assertEquals((Object)writeLevel, (Object)ct.getWriteConsistencyLevel());
            ++levelsChecked;
        }
        Preconditions.checkState((0 < levelsChecked ? 1 : 0) != 0);
    }

    @Test
    public void testReadConsistencyLevel() {
        int levelsChecked = 0;
        for (CLevel writeLevel : CLevel.values()) {
            StandardBaseTransactionConfig.Builder b = new StandardBaseTransactionConfig.Builder();
            ModifiableConfiguration mc = GraphDatabaseConfiguration.buildGraphConfiguration();
            mc.set(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY, (Object)writeLevel.name(), new String[0]);
            b.timestampProvider((TimestampProvider)TimestampProviders.MICRO);
            b.customOptions((Configuration)mc);
            CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)b.build());
            Assert.assertEquals((Object)writeLevel, (Object)ct.getReadConsistencyLevel());
            ++levelsChecked;
        }
        Preconditions.checkState((0 < levelsChecked ? 1 : 0) != 0);
    }

    @Test
    public void testTimestampProvider() {
        StandardBaseTransactionConfig txcfg = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.NANO);
        CassandraTransaction ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)TimestampProviders.NANO, (Object)ct.getConfiguration().getTimestampProvider());
        txcfg = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MICRO);
        ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)TimestampProviders.MICRO, (Object)ct.getConfiguration().getTimestampProvider());
        txcfg = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI);
        ct = new CassandraTransaction((BaseTransactionConfig)txcfg);
        Assert.assertEquals((Object)TimestampProviders.MILLI, (Object)ct.getConfiguration().getTimestampProvider());
    }
}

